/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.core.FastVector;
import weka.core.Instances;
import weka.gui.ExtensionFileFilter;
import weka.gui.visualize.ClassPanel;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class MatrixPanel
extends JPanel {
    private static final long serialVersionUID = -1232642719869188740L;
    private final Plot m_plotsPanel;
    protected final ClassPanel m_cp = new ClassPanel();
    protected JPanel optionsPanel;
    protected JSplitPane jp;
    protected JButton m_updateBt = new JButton("Update");
    protected JButton m_selAttrib = new JButton("Select Attributes");
    protected Instances m_data = null;
    protected JList m_attribList = new JList();
    protected final JScrollPane m_js = new JScrollPane();
    protected JComboBox m_classAttrib = new JComboBox();
    protected JSlider m_plotSize = new JSlider(50, 500, 100);
    protected JSlider m_pointSize = new JSlider(1, 10, 1);
    protected JSlider m_jitter = new JSlider(0, 20, 0);
    private Random rnd = new Random();
    private int[][] jitterVals;
    private int datapointSize = 1;
    protected JTextField m_resamplePercent = new JTextField(5);
    protected JButton m_resampleBt = new JButton("SubSample % :");
    protected JTextField m_rseed = new JTextField(5);
    private final JLabel m_plotSizeLb = new JLabel("PlotSize: [100]");
    private final JLabel m_pointSizeLb = new JLabel("PointSize: [10]");
    private int[] m_selectedAttribs;
    private int m_classIndex;
    private int[][] m_points;
    private int[] m_pointColors;
    private boolean[][] m_missing;
    private int[] m_type;
    private Dimension m_plotLBSizeD;
    private Dimension m_pointLBSizeD;
    private FastVector m_colorList = new FastVector();
    private static final Color[] m_defaultColors = new Color[]{Color.blue, Color.red, Color.cyan, new Color(75, 123, 130), Color.pink, Color.green, Color.orange, new Color(255, 0, 255), new Color(255, 0, 0), new Color(0, 255, 0), Color.black};
    private final Color fontColor = new Color(98, 101, 156);
    private final Font f = new Font("Dialog", 1, 11);

    public MatrixPanel() {
        this.m_rseed.setText("1");
        this.m_selAttrib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                final JDialog jd = new JDialog((JFrame)MatrixPanel.this.getTopLevelAncestor(), "Attribute Selection Panel", true);
                JPanel jp = new JPanel();
                JScrollPane js = new JScrollPane(MatrixPanel.this.m_attribList);
                JButton okBt = new JButton("OK");
                JButton cancelBt = new JButton("Cancel");
                final int[] savedSelection = MatrixPanel.this.m_attribList.getSelectedIndices();
                okBt.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        jd.dispose();
                    }
                });
                cancelBt.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MatrixPanel.this.m_attribList.setSelectedIndices(savedSelection);
                        jd.dispose();
                    }
                });
                jd.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        MatrixPanel.this.m_attribList.setSelectedIndices(savedSelection);
                        jd.dispose();
                    }
                });
                jp.add(okBt);
                jp.add(cancelBt);
                jd.getContentPane().add((Component)js, "Center");
                jd.getContentPane().add((Component)jp, "South");
                if (js.getPreferredSize().width < 200) {
                    jd.setSize(250, 250);
                } else {
                    jd.setSize(js.getPreferredSize().width + 10, 250);
                }
                jd.setLocation(MatrixPanel.this.m_selAttrib.getLocationOnScreen().x, MatrixPanel.this.m_selAttrib.getLocationOnScreen().y - jd.getHeight());
                jd.setVisible(true);
            }
        });
        this.m_updateBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MatrixPanel.this.initInternalFields();
                Plot a = MatrixPanel.this.m_plotsPanel;
                a.setCellSize(MatrixPanel.this.m_plotSize.getValue());
                Dimension d = new Dimension(MatrixPanel.this.m_selectedAttribs.length * (a.cellSize + a.extpad) + 2, MatrixPanel.this.m_selectedAttribs.length * (a.cellSize + a.extpad) + 2);
                a.setPreferredSize(d);
                a.setSize(a.getPreferredSize());
                a.setJitter(MatrixPanel.this.m_jitter.getValue());
                MatrixPanel.this.m_js.revalidate();
                MatrixPanel.this.m_cp.setColours(MatrixPanel.this.m_colorList);
                MatrixPanel.this.m_cp.setCindex(MatrixPanel.this.m_classIndex);
                MatrixPanel.this.repaint();
            }
        });
        this.m_updateBt.setPreferredSize(this.m_selAttrib.getPreferredSize());
        this.m_plotSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                MatrixPanel.this.m_plotSizeLb.setText("PlotSize: [" + MatrixPanel.this.m_plotSize.getValue() + "]");
                MatrixPanel.this.m_plotSizeLb.setPreferredSize(MatrixPanel.this.m_plotLBSizeD);
                MatrixPanel.this.m_jitter.setMaximum(MatrixPanel.this.m_plotSize.getValue() / 5);
            }
        });
        this.m_pointSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                MatrixPanel.this.m_pointSizeLb.setText("PointSize: [" + MatrixPanel.this.m_pointSize.getValue() + "]");
                MatrixPanel.this.m_pointSizeLb.setPreferredSize(MatrixPanel.this.m_pointLBSizeD);
                MatrixPanel.this.datapointSize = MatrixPanel.this.m_pointSize.getValue();
            }
        });
        this.m_resampleBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JLabel rseedLb = new JLabel("Random Seed: ");
                JTextField rseedTxt = MatrixPanel.this.m_rseed;
                JLabel percentLb = new JLabel("Subsample as");
                JLabel percent2Lb = new JLabel("% of input: ");
                final JTextField percentTxt = new JTextField(5);
                percentTxt.setText(MatrixPanel.this.m_resamplePercent.getText());
                JButton doneBt = new JButton("Done");
                final JDialog jd = new JDialog((JFrame)MatrixPanel.this.getTopLevelAncestor(), "Subsample % Panel", true){
                    private static final long serialVersionUID = -269823533147146296L;

                    @Override
                    public void dispose() {
                        MatrixPanel.this.m_resamplePercent.setText(percentTxt.getText());
                        super.dispose();
                    }
                };
                jd.setDefaultCloseOperation(2);
                doneBt.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        jd.dispose();
                    }
                });
                GridBagLayout gbl = new GridBagLayout();
                GridBagConstraints gbc = new GridBagConstraints();
                JPanel p1 = new JPanel(gbl);
                gbc.anchor = 17;
                gbc.fill = 2;
                gbc.insets = new Insets(0, 2, 2, 2);
                gbc.gridwidth = -1;
                p1.add((Component)rseedLb, gbc);
                gbc.weightx = 0.0;
                gbc.gridwidth = 0;
                gbc.weightx = 1.0;
                p1.add((Component)rseedTxt, gbc);
                gbc.insets = new Insets(8, 2, 0, 2);
                gbc.weightx = 0.0;
                p1.add((Component)percentLb, gbc);
                gbc.insets = new Insets(0, 2, 2, 2);
                gbc.gridwidth = -1;
                p1.add((Component)percent2Lb, gbc);
                gbc.gridwidth = 0;
                gbc.weightx = 1.0;
                p1.add((Component)percentTxt, gbc);
                gbc.insets = new Insets(8, 2, 2, 2);
                JPanel p3 = new JPanel(gbl);
                gbc.fill = 2;
                gbc.gridwidth = 0;
                gbc.weightx = 1.0;
                gbc.weighty = 0.0;
                p3.add((Component)p1, gbc);
                gbc.insets = new Insets(8, 4, 8, 4);
                p3.add((Component)doneBt, gbc);
                jd.getContentPane().setLayout(new BorderLayout());
                jd.getContentPane().add((Component)p3, "North");
                jd.pack();
                jd.setLocation(MatrixPanel.this.m_resampleBt.getLocationOnScreen().x, MatrixPanel.this.m_resampleBt.getLocationOnScreen().y - jd.getHeight());
                jd.setVisible(true);
            }
        });
        this.optionsPanel = new JPanel(new GridBagLayout());
        JPanel p2 = new JPanel(new BorderLayout());
        JPanel p3 = new JPanel(new GridBagLayout());
        JPanel p4 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.m_plotLBSizeD = this.m_plotSizeLb.getPreferredSize();
        this.m_pointLBSizeD = this.m_pointSizeLb.getPreferredSize();
        this.m_pointSizeLb.setText("PointSize: [1]");
        this.m_pointSizeLb.setPreferredSize(this.m_pointLBSizeD);
        this.m_resampleBt.setPreferredSize(this.m_selAttrib.getPreferredSize());
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 2, 2, 2);
        p4.add((Component)this.m_plotSizeLb, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        p4.add((Component)this.m_plotSize, gbc);
        gbc.weightx = 0.0;
        gbc.gridwidth = -1;
        p4.add((Component)this.m_pointSizeLb, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        p4.add((Component)this.m_pointSize, gbc);
        gbc.weightx = 0.0;
        gbc.gridwidth = -1;
        p4.add((Component)new JLabel("Jitter: "), gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        p4.add((Component)this.m_jitter, gbc);
        p4.add((Component)this.m_classAttrib, gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        p3.add((Component)this.m_updateBt, gbc);
        p3.add((Component)this.m_selAttrib, gbc);
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        gbc.anchor = 17;
        p3.add((Component)this.m_resampleBt, gbc);
        gbc.gridwidth = 0;
        p3.add((Component)this.m_resamplePercent, gbc);
        p2.setBorder(BorderFactory.createTitledBorder("Class Colour"));
        p2.add((Component)this.m_cp, "South");
        gbc.insets = new Insets(8, 5, 2, 5);
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = -1;
        this.optionsPanel.add((Component)p4, gbc);
        gbc.gridwidth = 0;
        this.optionsPanel.add((Component)p3, gbc);
        this.optionsPanel.add((Component)p2, gbc);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent cv) {
                MatrixPanel.this.m_js.setMinimumSize(new Dimension(MatrixPanel.this.getWidth(), MatrixPanel.this.getHeight() - MatrixPanel.this.optionsPanel.getPreferredSize().height - 10));
                MatrixPanel.this.jp.setDividerLocation(MatrixPanel.this.getHeight() - MatrixPanel.this.optionsPanel.getPreferredSize().height - 10);
            }
        });
        this.optionsPanel.setMinimumSize(new Dimension(0, 0));
        this.jp = new JSplitPane(0, this.m_js, this.optionsPanel);
        this.jp.setOneTouchExpandable(true);
        this.jp.setResizeWeight(1.0);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jp, "Center");
        for (int i = 0; i < m_defaultColors.length - 1; ++i) {
            this.m_colorList.addElement(m_defaultColors[i]);
        }
        this.m_selectedAttribs = this.m_attribList.getSelectedIndices();
        this.m_plotsPanel = new Plot();
        this.m_plotsPanel.setLayout(null);
        this.m_js.getHorizontalScrollBar().setUnitIncrement(10);
        this.m_js.getVerticalScrollBar().setUnitIncrement(10);
        this.m_js.setViewportView(this.m_plotsPanel);
        this.m_js.setColumnHeaderView(this.m_plotsPanel.getColHeader());
        this.m_js.setRowHeaderView(this.m_plotsPanel.getRowHeader());
        JLabel lb = new JLabel(" Plot Matrix");
        lb.setFont(this.f);
        lb.setForeground(this.fontColor);
        lb.setHorizontalTextPosition(0);
        this.m_js.setCorner("UPPER_LEFT_CORNER", lb);
        this.m_cp.setInstances(this.m_data);
        this.m_cp.setBorder(BorderFactory.createEmptyBorder(15, 10, 10, 10));
        this.m_cp.addRepaintNotify(this.m_plotsPanel);
    }

    public void initInternalFields() {
        int i;
        int i2;
        Instances inst = this.m_data;
        this.m_classIndex = this.m_classAttrib.getSelectedIndex();
        this.m_selectedAttribs = this.m_attribList.getSelectedIndices();
        double minC = 0.0;
        double maxC = 0.0;
        if (Double.parseDouble(this.m_resamplePercent.getText()) < 100.0) {
            inst = new Instances(this.m_data, 0, this.m_data.numInstances());
            inst.randomize(new Random(Integer.parseInt(this.m_rseed.getText())));
            inst = new Instances(inst, 0, (int)Math.round(Double.parseDouble(this.m_resamplePercent.getText()) / 100.0 * (double)inst.numInstances()));
        }
        this.m_points = new int[inst.numInstances()][this.m_selectedAttribs.length];
        this.m_pointColors = new int[inst.numInstances()];
        this.m_missing = new boolean[inst.numInstances()][this.m_selectedAttribs.length + 1];
        this.m_type = new int[2];
        this.jitterVals = new int[inst.numInstances()][2];
        if (!inst.attribute(this.m_classIndex).isNumeric()) {
            for (i2 = this.m_colorList.size(); i2 < inst.attribute(this.m_classIndex).numValues() + 1; ++i2) {
                Color pc = m_defaultColors[i2 % 10];
                int ija = i2 / 10;
                ija *= 2;
                for (int j = 0; j < ija; ++j) {
                    pc = pc.darker();
                }
                this.m_colorList.addElement(pc);
            }
            for (i2 = 0; i2 < inst.numInstances(); ++i2) {
                this.m_pointColors[i2] = inst.instance(i2).isMissing(this.m_classIndex) ? m_defaultColors.length - 1 : (int)inst.instance(i2).value(this.m_classIndex);
                this.jitterVals[i2][0] = this.rnd.nextInt(this.m_jitter.getValue() + 1) - this.m_jitter.getValue() / 2;
                this.jitterVals[i2][1] = this.rnd.nextInt(this.m_jitter.getValue() + 1) - this.m_jitter.getValue() / 2;
            }
        } else {
            for (i2 = 0; i2 < inst.numInstances(); ++i2) {
                if (inst.instance(i2).isMissing(this.m_classIndex)) continue;
                minC = maxC = inst.instance(i2).value(this.m_classIndex);
                break;
            }
            for (i2 = 1; i2 < inst.numInstances(); ++i2) {
                if (inst.instance(i2).isMissing(this.m_classIndex)) continue;
                if (minC > inst.instance(i2).value(this.m_classIndex)) {
                    minC = inst.instance(i2).value(this.m_classIndex);
                }
                if (!(maxC < inst.instance(i2).value(this.m_classIndex))) continue;
                maxC = inst.instance(i2).value(this.m_classIndex);
            }
            for (i2 = 0; i2 < inst.numInstances(); ++i2) {
                double r = (inst.instance(i2).value(this.m_classIndex) - minC) / (maxC - minC);
                r = r * 240.0 + 15.0;
                this.m_pointColors[i2] = (int)r;
                this.jitterVals[i2][0] = this.rnd.nextInt(this.m_jitter.getValue() + 1) - this.m_jitter.getValue() / 2;
                this.jitterVals[i2][1] = this.rnd.nextInt(this.m_jitter.getValue() + 1) - this.m_jitter.getValue() / 2;
            }
        }
        double[] min = new double[this.m_selectedAttribs.length];
        double max = 0.0;
        double[] ratio = new double[this.m_selectedAttribs.length];
        double cellSize = this.m_plotSize.getValue();
        double temp1 = 0.0;
        double temp2 = 0.0;
        for (int j = 0; j < this.m_selectedAttribs.length; ++j) {
            for (i = 0; i < inst.numInstances(); ++i) {
                max = 0.0;
                min[j] = 0.0;
                if (inst.instance(i).isMissing(this.m_selectedAttribs[j])) continue;
                min[j] = max = inst.instance(i).value(this.m_selectedAttribs[j]);
                break;
            }
            while (i < inst.numInstances()) {
                if (!inst.instance(i).isMissing(this.m_selectedAttribs[j])) {
                    if (inst.instance(i).value(this.m_selectedAttribs[j]) < min[j]) {
                        min[j] = inst.instance(i).value(this.m_selectedAttribs[j]);
                    }
                    if (inst.instance(i).value(this.m_selectedAttribs[j]) > max) {
                        max = inst.instance(i).value(this.m_selectedAttribs[j]);
                    }
                }
                ++i;
            }
            ratio[j] = cellSize / (max - min[j]);
        }
        boolean classIndexProcessed = false;
        for (int j = 0; j < this.m_selectedAttribs.length; ++j) {
            int i3;
            if (inst.attribute(this.m_selectedAttribs[j]).isNominal() || inst.attribute(this.m_selectedAttribs[j]).isString()) {
                temp1 = cellSize / (double)inst.attribute(this.m_selectedAttribs[j]).numValues();
                temp2 = temp1 / 2.0;
                for (i3 = 0; i3 < inst.numInstances(); ++i3) {
                    this.m_points[i3][j] = (int)Math.round(temp2 + temp1 * inst.instance(i3).value(this.m_selectedAttribs[j]));
                    if (!inst.instance(i3).isMissing(this.m_selectedAttribs[j])) continue;
                    this.m_missing[i3][j] = true;
                    if (this.m_selectedAttribs[j] != this.m_classIndex) continue;
                    this.m_missing[i3][this.m_missing[0].length - 1] = true;
                    classIndexProcessed = true;
                }
                continue;
            }
            for (i3 = 0; i3 < inst.numInstances(); ++i3) {
                this.m_points[i3][j] = (int)Math.round((inst.instance(i3).value(this.m_selectedAttribs[j]) - min[j]) * ratio[j]);
                if (!inst.instance(i3).isMissing(this.m_selectedAttribs[j])) continue;
                this.m_missing[i3][j] = true;
                if (this.m_selectedAttribs[j] != this.m_classIndex) continue;
                this.m_missing[i3][this.m_missing[0].length - 1] = true;
                classIndexProcessed = true;
            }
        }
        if (inst.attribute(this.m_classIndex).isNominal() || inst.attribute(this.m_classIndex).isString()) {
            this.m_type[0] = 1;
            this.m_type[1] = inst.attribute(this.m_classIndex).numValues();
        } else {
            this.m_type[1] = 0;
            this.m_type[0] = 0;
        }
        if (!classIndexProcessed) {
            for (i = 0; i < inst.numInstances(); ++i) {
                if (!inst.instance(i).isMissing(this.m_classIndex)) continue;
                this.m_missing[i][this.m_missing[0].length - 1] = true;
            }
        }
        this.m_cp.setColours(this.m_colorList);
    }

    public void setupAttribLists() {
        String[] tempAttribNames = new String[this.m_data.numAttributes()];
        this.m_classAttrib.removeAllItems();
        for (int i = 0; i < tempAttribNames.length; ++i) {
            String type;
            switch (this.m_data.attribute(i).type()) {
                case 1: {
                    type = " (Nom)";
                    break;
                }
                case 0: {
                    type = " (Num)";
                    break;
                }
                case 2: {
                    type = " (Str)";
                    break;
                }
                case 3: {
                    type = " (Dat)";
                    break;
                }
                case 4: {
                    type = " (Rel)";
                    break;
                }
                default: {
                    type = " (???)";
                }
            }
            tempAttribNames[i] = new String("Colour: " + this.m_data.attribute(i).name() + " " + type);
            this.m_classAttrib.addItem(tempAttribNames[i]);
        }
        if (this.m_data.classIndex() == -1) {
            this.m_classAttrib.setSelectedIndex(tempAttribNames.length - 1);
        } else {
            this.m_classAttrib.setSelectedIndex(this.m_data.classIndex());
        }
        this.m_attribList.setListData(tempAttribNames);
        this.m_attribList.setSelectionInterval(0, tempAttribNames.length - 1);
    }

    public void setPercent() {
        if (this.m_data.numInstances() > 700) {
            double percnt = 500.0 / (double)this.m_data.numInstances() * 100.0;
            percnt *= 100.0;
            percnt = Math.round(percnt);
            this.m_resamplePercent.setText("" + (percnt /= 100.0));
        } else {
            this.m_resamplePercent.setText("100");
        }
    }

    public void setInstances(Instances newInst) {
        this.m_data = newInst;
        this.setPercent();
        this.setupAttribLists();
        this.m_rseed.setText("1");
        this.initInternalFields();
        this.m_cp.setInstances(this.m_data);
        this.m_cp.setCindex(this.m_classIndex);
        this.m_updateBt.doClick();
    }

    public static void main(String[] args) {
        final JFrame jf = new JFrame("Weka Explorer: MatrixPanel");
        JButton setBt = new JButton("Set Instances");
        Instances data = null;
        try {
            if (args.length == 1) {
                data = new Instances(new BufferedReader(new FileReader(args[0])));
            } else {
                System.out.println("Usage: MatrixPanel <arff file>");
                System.exit(-1);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        final MatrixPanel mp = new MatrixPanel();
        mp.setInstances(data);
        setBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(new File(System.getProperty("user.dir")));
                ExtensionFileFilter myfilter = new ExtensionFileFilter("arff", "Arff data files");
                chooser.setFileFilter(myfilter);
                int returnVal = chooser.showOpenDialog(jf);
                if (returnVal == 0) {
                    try {
                        System.out.println("You chose to open this file: " + chooser.getSelectedFile().getName());
                        Instances in = new Instances(new FileReader(chooser.getSelectedFile().getAbsolutePath()));
                        mp.setInstances(in);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        jf.getContentPane().setLayout(new BorderLayout());
        jf.getContentPane().add((Component)mp, "Center");
        jf.getContentPane().add((Component)setBt, "South");
        jf.getContentPane().setFont(new Font("SansSerif", 0, 11));
        jf.setDefaultCloseOperation(3);
        jf.setSize(800, 600);
        jf.setVisible(true);
        jf.repaint();
    }

    private class Plot
    extends JPanel
    implements MouseMotionListener,
    MouseListener {
        private static final long serialVersionUID = -1721245738439420882L;
        int extpad = 3;
        int intpad = 4;
        int cellSize = 100;
        int cellRange = 100;
        int lastx = 0;
        int lasty = 0;
        int jitter = 0;
        Rectangle r;
        FontMetrics fm;
        int lastxpos;
        int lastypos;
        JPanel jPlColHeader;
        JPanel jPlRowHeader;

        public Plot() {
            this.setToolTipText("blah");
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.initialize();
        }

        public void initialize() {
            this.lastypos = 0;
            this.lastxpos = 0;
            this.cellRange = this.cellSize;
            this.cellSize = this.cellRange + 2 * this.intpad;
            this.jPlColHeader = new JPanel(){
                private static final long serialVersionUID = -9098547751937467506L;
                Rectangle r;

                @Override
                public void paint(Graphics g) {
                    this.r = g.getClipBounds();
                    g.setColor(this.getBackground());
                    g.fillRect(this.r.x, this.r.y, this.r.width, this.r.height);
                    g.setFont(MatrixPanel.this.f);
                    Plot.this.fm = g.getFontMetrics();
                    int xpos = 0;
                    int ypos = 0;
                    int attribWidth = 0;
                    g.setColor(MatrixPanel.this.fontColor);
                    xpos = Plot.this.extpad;
                    ypos = Plot.this.extpad + Plot.this.fm.getHeight();
                    for (int i = 0; i < MatrixPanel.this.m_selectedAttribs.length; ++i) {
                        if (xpos + Plot.this.cellSize < this.r.x) {
                            xpos += Plot.this.cellSize + Plot.this.extpad;
                            continue;
                        }
                        if (xpos > this.r.x + this.r.width) break;
                        attribWidth = Plot.this.fm.stringWidth(MatrixPanel.this.m_data.attribute(MatrixPanel.this.m_selectedAttribs[i]).name());
                        g.drawString(MatrixPanel.this.m_data.attribute(MatrixPanel.this.m_selectedAttribs[i]).name(), attribWidth < Plot.this.cellSize ? xpos + (Plot.this.cellSize / 2 - attribWidth / 2) : xpos, ypos);
                        xpos += Plot.this.cellSize + Plot.this.extpad;
                    }
                    Plot.this.fm = null;
                    this.r = null;
                }

                @Override
                public Dimension getPreferredSize() {
                    Plot.this.fm = this.getFontMetrics(this.getFont());
                    return new Dimension(MatrixPanel.this.m_selectedAttribs.length * (Plot.this.cellSize + Plot.this.extpad), 2 * Plot.this.extpad + Plot.this.fm.getHeight());
                }
            };
            this.jPlRowHeader = new JPanel(){
                private static final long serialVersionUID = 8474957069309552844L;
                Rectangle r;

                @Override
                public void paint(Graphics g) {
                    this.r = g.getClipBounds();
                    g.setColor(this.getBackground());
                    g.fillRect(this.r.x, this.r.y, this.r.width, this.r.height);
                    g.setFont(MatrixPanel.this.f);
                    Plot.this.fm = g.getFontMetrics();
                    int xpos = 0;
                    int ypos = 0;
                    g.setColor(MatrixPanel.this.fontColor);
                    xpos = Plot.this.extpad;
                    ypos = Plot.this.extpad;
                    for (int j = MatrixPanel.this.m_selectedAttribs.length - 1; j >= 0; --j) {
                        if (ypos + Plot.this.cellSize < this.r.y) {
                            ypos += Plot.this.cellSize + Plot.this.extpad;
                            continue;
                        }
                        if (ypos > this.r.y + this.r.height) break;
                        g.drawString(MatrixPanel.this.m_data.attribute(MatrixPanel.this.m_selectedAttribs[j]).name(), xpos + Plot.this.extpad, ypos + Plot.this.cellSize / 2);
                        xpos = Plot.this.extpad;
                        ypos += Plot.this.cellSize + Plot.this.extpad;
                    }
                    this.r = null;
                }

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(100 + Plot.this.extpad, MatrixPanel.this.m_selectedAttribs.length * (Plot.this.cellSize + Plot.this.extpad));
                }
            };
            this.jPlColHeader.setFont(MatrixPanel.this.f);
            this.jPlRowHeader.setFont(MatrixPanel.this.f);
            this.setFont(MatrixPanel.this.f);
        }

        public JPanel getRowHeader() {
            return this.jPlRowHeader;
        }

        public JPanel getColHeader() {
            return this.jPlColHeader;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Graphics g = this.getGraphics();
            int xpos = this.extpad;
            int ypos = this.extpad;
            for (int j = MatrixPanel.this.m_selectedAttribs.length - 1; j >= 0; --j) {
                for (int i = 0; i < MatrixPanel.this.m_selectedAttribs.length; ++i) {
                    if (e.getX() >= xpos && e.getX() <= xpos + this.cellSize + this.extpad && e.getY() >= ypos && e.getY() <= ypos + this.cellSize + this.extpad) {
                        if (xpos != this.lastxpos || ypos != this.lastypos) {
                            g.setColor(Color.red);
                            g.drawRect(xpos - 1, ypos - 1, this.cellSize + 1, this.cellSize + 1);
                            if (this.lastxpos != 0 && this.lastypos != 0) {
                                g.setColor(this.getBackground().darker());
                                g.drawRect(this.lastxpos - 1, this.lastypos - 1, this.cellSize + 1, this.cellSize + 1);
                            }
                            this.lastxpos = xpos;
                            this.lastypos = ypos;
                        }
                        return;
                    }
                    xpos += this.cellSize + this.extpad;
                }
                xpos = this.extpad;
                ypos += this.cellSize + this.extpad;
            }
            if (this.lastxpos != 0 && this.lastypos != 0) {
                g.setColor(this.getBackground().darker());
                g.drawRect(this.lastxpos - 1, this.lastypos - 1, this.cellSize + 1, this.cellSize + 1);
            }
            this.lastypos = 0;
            this.lastxpos = 0;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int i = 0;
            int j = 0;
            boolean found = false;
            int xpos = this.extpad;
            int ypos = this.extpad;
            for (j = MatrixPanel.this.m_selectedAttribs.length - 1; j >= 0; --j) {
                for (i = 0; i < MatrixPanel.this.m_selectedAttribs.length; ++i) {
                    if (e.getX() >= xpos && e.getX() <= xpos + this.cellSize + this.extpad && e.getY() >= ypos && e.getY() <= ypos + this.cellSize + this.extpad) {
                        found = true;
                        break;
                    }
                    xpos += this.cellSize + this.extpad;
                }
                if (found) break;
                xpos = this.extpad;
                ypos += this.cellSize + this.extpad;
            }
            if (!found) {
                return;
            }
            JFrame jf = new JFrame("Weka Explorer: Visualizing " + MatrixPanel.this.m_data.relationName());
            VisualizePanel vp = new VisualizePanel();
            try {
                PlotData2D pd = new PlotData2D(MatrixPanel.this.m_data);
                pd.setPlotName("Master Plot");
                vp.setMasterPlot(pd);
                vp.setXIndex(MatrixPanel.this.m_selectedAttribs[i]);
                vp.setYIndex(MatrixPanel.this.m_selectedAttribs[j]);
                vp.m_ColourCombo.setSelectedIndex(MatrixPanel.this.m_classIndex);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            jf.getContentPane().add(vp);
            jf.setSize(800, 600);
            jf.setVisible(true);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        public void setJitter(int newjitter) {
            this.jitter = newjitter;
        }

        public void setCellSize(int newCellSize) {
            this.cellSize = newCellSize;
            this.initialize();
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            int xpos = this.extpad;
            int ypos = this.extpad;
            for (int j = MatrixPanel.this.m_selectedAttribs.length - 1; j >= 0; --j) {
                for (int i = 0; i < MatrixPanel.this.m_selectedAttribs.length; ++i) {
                    if (event.getX() >= xpos && event.getX() <= xpos + this.cellSize + this.extpad && event.getY() >= ypos && event.getY() <= ypos + this.cellSize + this.extpad) {
                        return "X: " + MatrixPanel.this.m_data.attribute(MatrixPanel.this.m_selectedAttribs[i]).name() + " Y: " + MatrixPanel.this.m_data.attribute(MatrixPanel.this.m_selectedAttribs[j]).name() + " (click to enlarge)";
                    }
                    xpos += this.cellSize + this.extpad;
                }
                xpos = this.extpad;
                ypos += this.cellSize + this.extpad;
            }
            return "Matrix Panel";
        }

        public void paintGraph(Graphics g, int xattrib, int yattrib, int xpos, int ypos) {
            g.setColor(this.getBackground().darker().darker());
            g.drawRect(xpos - 1, ypos - 1, this.cellSize + 1, this.cellSize + 1);
            g.setColor(Color.white);
            g.fillRect(xpos, ypos, this.cellSize, this.cellSize);
            for (int i = 0; i < MatrixPanel.this.m_points.length; ++i) {
                int y;
                int x;
                if (MatrixPanel.this.m_missing[i][yattrib] || MatrixPanel.this.m_missing[i][xattrib]) continue;
                if (MatrixPanel.this.m_type[0] == 0) {
                    if (MatrixPanel.this.m_missing[i][MatrixPanel.this.m_missing[0].length - 1]) {
                        g.setColor(m_defaultColors[m_defaultColors.length - 1]);
                    } else {
                        g.setColor(new Color(MatrixPanel.this.m_pointColors[i], 150, 255 - MatrixPanel.this.m_pointColors[i]));
                    }
                } else {
                    g.setColor((Color)MatrixPanel.this.m_colorList.elementAt(MatrixPanel.this.m_pointColors[i]));
                }
                if (MatrixPanel.this.m_points[i][xattrib] + MatrixPanel.this.jitterVals[i][0] < 0 || MatrixPanel.this.m_points[i][xattrib] + MatrixPanel.this.jitterVals[i][0] > this.cellRange) {
                    if (this.cellRange - MatrixPanel.this.m_points[i][yattrib] + MatrixPanel.this.jitterVals[i][1] < 0 || this.cellRange - MatrixPanel.this.m_points[i][yattrib] + MatrixPanel.this.jitterVals[i][1] > this.cellRange) {
                        x = this.intpad + MatrixPanel.this.m_points[i][xattrib];
                        y = this.intpad + (this.cellRange - MatrixPanel.this.m_points[i][yattrib]);
                    } else {
                        x = this.intpad + MatrixPanel.this.m_points[i][xattrib];
                        y = this.intpad + (this.cellRange - MatrixPanel.this.m_points[i][yattrib]) + MatrixPanel.this.jitterVals[i][1];
                    }
                } else if (this.cellRange - MatrixPanel.this.m_points[i][yattrib] + MatrixPanel.this.jitterVals[i][1] < 0 || this.cellRange - MatrixPanel.this.m_points[i][yattrib] + MatrixPanel.this.jitterVals[i][1] > this.cellRange) {
                    x = this.intpad + MatrixPanel.this.m_points[i][xattrib] + MatrixPanel.this.jitterVals[i][0];
                    y = this.intpad + (this.cellRange - MatrixPanel.this.m_points[i][yattrib]);
                } else {
                    x = this.intpad + MatrixPanel.this.m_points[i][xattrib] + MatrixPanel.this.jitterVals[i][0];
                    y = this.intpad + (this.cellRange - MatrixPanel.this.m_points[i][yattrib]) + MatrixPanel.this.jitterVals[i][1];
                }
                if (MatrixPanel.this.datapointSize == 1) {
                    g.drawLine(x + xpos, y + ypos, x + xpos, y + ypos);
                    continue;
                }
                g.drawOval(x + xpos - MatrixPanel.this.datapointSize / 2, y + ypos - MatrixPanel.this.datapointSize / 2, MatrixPanel.this.datapointSize, MatrixPanel.this.datapointSize);
            }
            g.setColor(MatrixPanel.this.fontColor);
        }

        public void paintME(Graphics g) {
            this.r = g.getClipBounds();
            g.setColor(this.getBackground());
            g.fillRect(this.r.x, this.r.y, this.r.width, this.r.height);
            g.setColor(MatrixPanel.this.fontColor);
            int xpos = 0;
            int ypos = 0;
            xpos = this.extpad;
            ypos = this.extpad;
            for (int j = MatrixPanel.this.m_selectedAttribs.length - 1; j >= 0; --j) {
                if (ypos + this.cellSize < this.r.y) {
                    ypos += this.cellSize + this.extpad;
                    continue;
                }
                if (ypos > this.r.y + this.r.height) break;
                for (int i = 0; i < MatrixPanel.this.m_selectedAttribs.length; ++i) {
                    if (xpos + this.cellSize < this.r.x) {
                        xpos += this.cellSize + this.extpad;
                        continue;
                    }
                    if (xpos > this.r.x + this.r.width) break;
                    this.paintGraph(g, i, j, xpos, ypos);
                    xpos += this.cellSize + this.extpad;
                }
                xpos = this.extpad;
                ypos += this.cellSize + this.extpad;
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            this.paintME(g);
        }
    }
}

