### Name: ordrating
### Title: MCMC for Unidimensional Ordinal IRT Model
### Aliases: ordrating
### Keywords: models multivariate

### ** Examples

## Not run: 
##D ## Mondo Times example from Ho & Quinn (nd).
##D ## may have to increase stack limit to run this example on some machines
##D 
##D data(Mondo)
##D 
##D ord.out <- ordrating(Mondo, beta.constraint=1, tune=.035, 
##D                      ma=1, mb=-5, vinva=1, vinvb=0.05,
##D                      gamma.start=c(-300, 0, 1.5, 3.0, 4.5, 300),
##D                      thin=20, burnin=20000, mcmc=100000, verbose=1000)
##D 
##D plot(ord.out)
##D summary(ord.out) 
##D 
##D 
##D 
##D ## subsetting the Mondo data to include only raters who rated 5 or more 
##D ## outlets (should avoid any stacksize problems)
##D 
##D Mondo.sub <- Mondo[apply(!is.na(Mondo), 1, sum) >= 5, ]
##D ## also getting rid of outlets that are not rated now
##D Mondo.sub <- Mondo.sub[,apply(is.na(Mondo.sub), 2, mean) != 1] 
##D 
##D ord.out <- ordrating(Mondo.sub, beta.constraint=1, tune=.035, 
##D                      ma=1, mb=-5, vinva=1, vinvb=0.05,
##D                      gamma.start=c(-300, 0, 1.5, 3.0, 4.5, 300),
##D                      thin=20, burnin=20000, mcmc=100000, verbose=1000)
##D 
##D plot(ord.out)
##D summary(ord.out) 
##D 
## End(Not run)



