### Name: iir
### Title: INFINITE IMPULSE RESPONSE FILTERS
### Aliases: iir lp hp bp


### ** Examples


# Sine waves plus linear trend:
t <- seq(0, 10, by = 0.02)
x <- sin(2 * pi * 1 * t) + sin(2 * pi * 5 * t) + 0.2 * t
sines <- vector(mode = "list")
sines[[1]] <- list(amp = x, dt = 0.02, N = length(x), nzhour = 0,
                   nzmin = 0, nzsec = 0, nzmsec = 0, b = 0)
class(sines) <- "rsac"
plot(sines)
f1 <- iir(sines, fl = 0.5, fh = 1.5, type = "BP", proto = "BU")
lines(f1, col = "blue")
f2 <- iir(sines, fl = 0.5, fh = 1.5, type = "BP", proto = "BU",
          zerophase = FALSE)
lines(f2, col = "red")

# Real data
data(srosa)
plot(srosa)
spect(srosa, log = "no")
testf <- lp(srosa, c = 2)
spect(testf, log = "no")
testf <- bp(srosa, c = c(2, 4))
spect(testf, log = "no")




