### Name: spect
### Title: SPECTRAL DENSITY ESTIMATION
### Aliases: spect


### ** Examples


data(srosa)
data(sumatra)

eqs <- c(srosa[1], sumatra[11])

spect(eqs)

spect(eqs, spans = 101)

spect(eqs, spans = 201)

spect(eqs, spans = c(101, 151))

spect(eqs, spans = c(101, 151),
      log = "yes")

getdelta <- function(X){
  delta <- gcp(s = list(lat = X$stla, lon = X$stlo),
               e = list(lat = X$evla, lon = X$evlo))$a}
del <- sapply(X = sumatra, getdelta)

sum <- sumatra[c(1, 3, 4, 9)]

spect(sum, plot = TRUE, spans = c(101, 151),
      log = "no", xlim = c(0, 0.15))




