### Name: modelsCompare
### Title: Functions for comparing results: LRE, compare, agrees
### Aliases: LRE modelsCompare modelsAgree modelSummary modelBetas
### Keywords: misc debugging

### ** Examples


# simple LRE examples
LRE(1.001,1) # roughly 3 significant digits agreement
LRE(1,1) # complete agreement
LRE(20,1) # complete disagreement

# compare two models

if (is.R()) {
 hasNmle=require(nlme,quietly=TRUE) 
}  else {
  hasNmle=require(nlme3,quietly=TRUE)
}

if (hasNmle) { 
  O2<-Orthodont
  O3<-Orthodont
  
  O2[,2]<-O2[,2]+.1                                    
  O3[,2]<-O2[,2]+.11 
  if (is.R()) {                                   
    fm1<- lmList(Orthodont)
    fm2<- lmList(O2)
    fm3<- lmList(O2)
  } else {
    # workaround bug in lmlist in S-Plus
    fm1<- eval(substitute(lmList(Orthodont)))
    fm2<- eval(substitute(lmList(O2)))
    fm3<- eval(substitute(lmList(O2)))
  }

  # do the three models agree? 
  print(modelsAgree(list(fm1,fm2,fm2)))

  # show details of diagreement between first 2 models
  print(modelsCompare(fm1,fm2))

  #compare betas at 2 significant digits
  print(modelsAgree(fm1,fm2,digits=2,param.function=modelBetas))
  #compare betas at 1 significant digit
  print(modelsAgree(fm1,fm2,digits=1,param.function=modelBetas))
}

## Don't show: 
  # unit test
if (is.R()){
  selfTest=get("modelsCompareSelfTest",envir=environment(LRE))
} else {
  selfTest=modelsCompareSelfTest
}
if (!selfTest()) {
        warning("failed self-test")
}
## End Don't show




