### Name: dehaan
### Title: dehaan global optimality test
### Aliases: dehaan
### Keywords: manip misc math htest

### ** Examples


  # The deHaan test is constructed as a maximum likelihood
  # test, with negative values for the likelihood.  The BOD problem
  # is a non-linear least squares minimization problem.  This test
  # is implemented using the negative of the sum of squares for consistency
  # with the deHaan framework of maximum likelihood.

  BOD <-
structure(list(Time = c(1, 2, 3, 4, 5, 7), demand = c(8.3, 10.3, 
19, 16, 15.6, 19.8)), .Names = c("Time", "demand"), row.names = c("1", 
"2", "3", "4", "5", "6"), class = "data.frame", reference = "A1.4, p. 270")
  stval<-expand.grid(A = seq(10, 100, 10), lrc = seq(.5, .8, .1))
  llfun<-function(A,lrc,BOD)
        -sum((BOD$demand - A*(1-exp(-exp(lrc)*BOD$Time)))^2)
  lls<-NULL 
  for (i in 1:nrow(stval))  {
     lls = rbind(lls, llfun(stval[i,1], stval[i,2],BOD))
  }
  fm1 <- nls(demand ~ A*(1-exp(-exp(lrc)*Time)),  
                data = BOD, start = c(A = 20, lrc = log(.35)))
  ss = -sum(resid(fm1)^2)
  dehaan(lls, ss)

## Don't show: 
  if (is.R()){
    selfTest=get("dehaanSelftest",envir=environment(dehaan))
  } else {
    selfTest=dehaanSelftest
  }
  if (!selfTest()) {
        warning("failed self-test")
  }
## End Don't show



