### Name: Distribution Test Data, and log relative error function
### Title: Benchmark data to test the accuracy of statistical distribution
###   functions, function to compute log relative error
### Aliases: chisqtst ftst gammatst normtst ttst
### Keywords: misc debugging

### ** Examples


# simple LRE examples
LRE(1.001,1) # roughly 3 significant digits agreement
LRE(1,1) # complete agreement
LRE(20,1) # complete disagreement

#
# how accurate are student's t-test functions?
#

data(ttst)
# compute t quantiles using benchmark data
tqt = qt(ttst$p,ttst$df)

# compute log-relative-error (LRE) of  qt() results, compared to 
# correct answers

lrq = LRE(tqt, ttst$invt);

# if there are entries with LRE's of < 5, there may be
# significant inaccuracies in the qt() function

table(trunc(lrq))

# now repeat process, for pt()

tpt = pt(ttst$invt,ttst$df)
lrp= LRE(tpt, ttst$pinvt);
table(trunc(lrp))




