### Name: sensitivityZelig
### Title: Perturbations-based Sensitivity Analysis of Zelig Models
### Aliases: pzelig sensitivityZelig
### Keywords: misc optimize

### ** Examples


# Sensitivity analysis of the classic longley data, as run through zelig.
#
# Note: Compare to the example documented under the main perturb page.

# example requires Zelig.

if(!is.R()){
  # splus version of require ignores quietly!
  ow<-options(warn=-1)
} else {
   data(longley)
   # accuracy supplies longley for SPLUS automagically, for examples only
}

# workaround for Zelig < 3.4 & R 2.8 & possible broken build environment
goodZelig <- require(Zelig,quietly=TRUE) && (!inherits(try(zelig(Employed~GNP,"ls",longley,cite=FALSE),silent=TRUE),"try-error"))
if (!is.R()) {
      options(ow)
}
if (goodZelig) { 
   
   # not used due to zelig bug: zelig.out=zelig(Employed~.,"ls",longley) 
   # run longley regression
   
   zelig.out=try(zelig(Employed~GNP.deflator+GNP+Unemployed+Armed.Forces+Population+Year,"ls",longley),silent=TRUE)

   # default settings
   perturb.zelig.out = sensitivityZelig(zelig.out)                 

   # Note: without zelig, the preceding would be:  perturb.out = perturb(longley,lm,Employed~.) 

   # plots the perturbed lm replications individually
   plot(perturb.zelig.out)        
   # summarizes the overall sensitivity of coefficient estimates
   summary(perturb.zelig.out)             
   plot(summary(perturb.zelig.out))
   
   # since the "ls" model relies on "lm" which supports anova, can summarize
   # using anova
   anova(perturb.zelig.out)
   plot(anova(perturb.zelig.out))
   
   # Up to this point, we could have done this without Zelig... here's the fun part.
  
   # set values of explanatory variables
   setx.out=setx(perturb.zelig.out, Year=1955)       

   # Note: could also have used setx.out=setx(z,Year=1955)  instead of the line above,
   #       or  simply called psim() below without setx.out, which would default to using setx(perturb.zelig.out)

   # use simulation to predict value of explanatory variable based on
   # 
   sim.perturb.zelig.out = psim(perturb.zelig.out,setx.out)

   # this plots the profile of the predicted distribution of the explanatory variable, Employed
   # around the point wher Year=1955, and other explanatory variables are at their midpoints

   plot(sim.perturb.zelig.out)

   # this provides a summary of the predicted distribution of the explanatory variable

   print(summary(sim.perturb.zelig.out))
   
 }
 if (!is.R()) {
   options(ow)
 }



