### Name: runifS
### Title: Function to return TRUE (not pseudo) random numbers, based on
###   system and networked entropy collection.
### Aliases: trueRandom resetSeed runifT rnormS rstarMix runifS
### Keywords: misc datagen distribution

### ** Examples

# note, if you are using Windows, you must be on-line
# to get to entropy generator, will fall-back to pseudo-random
# numbers when off-line

## Don't show: 
# only needed  to pass R CMD check on online windows
ow = options("warn"=0)
## End Don't show

# reset the seed for runif() based on a true random value

resetSeed()
y=runif(100000)
ty= table(trunc(5*y))
print(ty)
if (is.R()) {
  chisq.test(ty)
} else {
  chisq.test(t(cbind(as.numeric(names(ty)),as.matrix(ty))))
}

## Not run: 
##D # generate true random values directly (may block for long periods if 
##D # if entropy pool is empty)
##D y=runifS(100000)
##D ty= table(trunc(5*y))
##D print(ty)
##D if (is.R()) {
##D   chisq.test(ty)
##D } else {
##D   chisq.test(t(cbind(as.numeric(names(ty)),as.matrix(ty))))
##D }
##D 
##D y=runifT(100)
##D ty= table(trunc(5*y))
##D print(ty);
##D chisq.test(ty)
## End(Not run)
## Don't show: 
options(ow);
## End Don't show




