###################################################
### chunk number 1: 
###################################################
sdp.formula1<-function(x){ n <- length(x); sqrt(n*sum(x^2)-sum(x)^2)/n }
sdp.formula2<-function(x){ sum(sqrt((x-sum(x)/length(x))^2))/length(x)}
sdp.formula3<-function(x){ sqrt(var(x)*(length(x)-1)/length(x))}


###################################################
### chunk number 2: 
###################################################
testMat<-function(len = 50, digits = c(3,5,7,9,11,13,15,17,19)){
   len <- 2*len
   dat <- NULL
   for (i in digits) {
      dat <- as.data.frame(
          cbind (dat , 1:len %%2+10^i )  )
   }
   names(dat) <- as.character(digits)
   return(dat)
}


###################################################
### chunk number 3: 
###################################################
dat <- testMat(4)
print(rbind(sapply(dat,sdp.formula1), sapply(dat,sdp.formula2), sapply(dat,sdp.formula3)),digits=3)


###################################################
### chunk number 4: 
###################################################
dat <- testMat(10)
print(rbind(sapply(dat,sdp.formula1), sapply(dat,sdp.formula2), sapply(dat,sdp.formula3)),digits=3)


###################################################
### chunk number 5: 
###################################################
dat <- testMat(50)
print(rbind(sapply(dat,sdp.formula1), sapply(dat,sdp.formula2), sapply(dat,sdp.formula3)),digits=3)


###################################################
### chunk number 6: 
###################################################
     library("accuracy")
      options(prompt = "R> ")


###################################################
### chunk number 7: 
###################################################
     data("ttst")
     tqt <- qt(ttst$p,ttst$df)


###################################################
### chunk number 8: 
###################################################
     lrq <- LRE(tqt, ttst$invt)
     table(round(lrq))


###################################################
### chunk number 9: 
###################################################
    library("stats4")
     x <- 0:10
     y <- c(26, 17, 13, 12, 20, 5, 9, 8, 5, 4, 8)
     ll <- function(ymax=15, xhalf=6)
          -sum(stats::dpois(y, lambda=ymax/(1+x/xhalf), log=TRUE))
         
     fit1<-mle(ll)
     fit2<- mle(ll,method="Nelder-Mead")
     fit3<- mle(ll,method="CG")
     fit4<- mle(ll,method="SANN")
     fit5<- mle(ll,method="L-BFGS-B")


###################################################
### chunk number 10: 
###################################################
      modelsCompare(list(fit1,fit2,fit3,fit4,fit5), param.function=modelBetas )


###################################################
### chunk number 11: 
###################################################
ow<-options(width=50)


###################################################
### chunk number 12: 
###################################################
 (min( as.vector( modelsCompare(list(fit1,fit2),
	 param.function=function(x)coef(summary(x)) )))>=2)
 modelsAgree(fit1,fit2,digits=2,param.function=modelBetas)


###################################################
### chunk number 13: 
###################################################
options(ow)


###################################################
### chunk number 14: 
###################################################
     library("accuracy")
     data("longley")


###################################################
### chunk number 15: 
###################################################
     plongley <- sensitivity(longley,lm,Employed~.,ptb.R=500)  


###################################################
### chunk number 16: plot1 eval=FALSE
###################################################
##  plot(summary(plongley))


###################################################
### chunk number 17: plot1a
###################################################
 plot(summary(plongley))


###################################################
### chunk number 18: 
###################################################
     print(summary(plongley),digits=1)


###################################################
### chunk number 19: 
###################################################
    if (require("NISTnls",quietly=TRUE)) {
     data("Thurber",package="NISTnls")
     fm1 <- nls(y ~ (b1+x*(b2+x*(b3+b4*x))) / (1+x*(b5+x*(b6+x*b7))),
                data = Thurber, trace = FALSE,
                start = c(b1 = 1000, b2 = 1000, b3 = 400, b4 = 40,
                          b5 = 0.7, b6 = 0.3, b7 = 0.03))
thurber.out <- sensitivity(Thurber,nls,y ~ (b1+x*(b2+x*(b3+b4*x)) / (1+x*(b5+x*(b6+x*b7)))),          
start <- c(b1 = 1000,  b2 = 1000, b3 = 400, b4 = 40, b5 = 0.7, b6 = 0.3, b7 = 0.03))
print(summary(thurber.out), digits=1)
	}


###################################################
### chunk number 20: 
###################################################
  if (require(MASS,quietly=TRUE)) {
    plongleym <- sensitivity(longley,lm,Employed~.,
      ptb.rangen.ismatrix=TRUE,
      ptb.ran.gen=
      function(x,size=1){
             mvrnorm(n=dim(x)[1],mu=rep(0,dim(x)[1]),
                     Sigma=matrix(.9,nrow=dim(x)[1],ncol=dim(x)[1]))*size+x}
    )
  }


###################################################
### chunk number 21: 
###################################################
     data("anorexia",package="MASS")
     panorexia <- sensitivity(anorexia, glm, Postwt ~ Prewt + Treat + offset(Prewt),
          family=gaussian, 
         ptb.R=500, ptb.ran.gen=list(PTBi,PTBus,PTBus), ptb.s=c(1,.01,.01) )
     print(summary(panorexia),digits=1)


###################################################
### chunk number 22: 
###################################################
     mleD<-function(data,lld,...) {
           f <- formals(lld)
           f[1] <- NULL
           ll <-function()  {
              cl <- as.list(match.call())
              cl[1] <- NULL
              cl$data <- as.name("data")
              do.call(lld,cl)
           }
           formals(ll) <- f
           
           # call mle
           mle(ll,...)
     }


###################################################
### chunk number 23: 
###################################################
     #library(stats4)
     #dat <- as.data.frame(cbind( 0:10 , c(26, 17, 13, 12, 20, 5, 9, 8, 5, 4, 8) ))
     llD<-function(data, ymax=15, xhalf=6)
         -sum(stats::dpois(data[[2]], lambda=ymax/(1+data[[1]]/xhalf), log=TRUE))
     #print(summary(sensitivity(dat, mleD,llD)), digits=2)


###################################################
### chunk number 24: 
###################################################
data(longley)
goodZelig <- require(Zelig,quietly=TRUE) && (!inherits(try(zelig(Employed~GNP,"ls",longley,cite=FALSE), silent=TRUE),"try-error"))
 if (goodZelig) {
	# Avoid 'Employed~.' because of Zelig bug
        zelig.out <- zelig(Employed~GNP.deflator+GNP+Unemployed+Armed.Forces+Population+Year,"ls",longley) 
        perturb.zelig.out <- sensitivityZelig(zelig.out)                   
  }


###################################################
### chunk number 25: 
###################################################

if (goodZelig) {
        # set values of explanatory variables
        setx.out <- setx(perturb.zelig.out, Year=1955) 
}


###################################################
### chunk number 26: 
###################################################
if (goodZelig) {
        # run simulation
        sim.perturb.zelig.out <- psim(perturb.zelig.out,setx.out)
}


###################################################
### chunk number 27: 
###################################################
if (goodZelig) {
  summary(sim.perturb.zelig.out)
}


###################################################
### chunk number 28: plot2 eval=FALSE
###################################################
##  if (goodZelig) {
## 
##                # summarize
##         plot(sim.perturb.zelig.out)
##  } else {
## 	plot(1,1) # dummy plot to cause SWEAVE not to bork
##  }


###################################################
### chunk number 29: plot2a
###################################################
 if (goodZelig) {

               # summarize
        plot(sim.perturb.zelig.out)
 } else {
	plot(1,1) # dummy plot to cause SWEAVE not to bork
 }


###################################################
### chunk number 30: 
###################################################
      # birthday spacings test for random distributions
     birthday<-function(x,n=2^20) {
        spacings <- diff(trunc((x*.Machine$integer.max) %% n  ))
        tab <- table(spacings)
        tab <- tab[which(tab>1)]
        chisq.test(sample(tab,200,replace=T))
     }


###################################################
### chunk number 31: 
###################################################
# set RNGkind for faster speed during demo
RNGkind(kind="Super")


###################################################
### chunk number 32: 
###################################################
     # good quality random number sequence require a true random seed
     old.seed<-resetSeed() 
     y=runif(1000000)
     birthday(y)


###################################################
### chunk number 33: 
###################################################
     # better, reseeding every 10000 draws
     y <- runifS(1000000)
     birthday(y)
     
     # even better, but quite slow
     # y <- runifT(1000000)


###################################################
### chunk number 34: 
###################################################
  data("BOD")

       stval <- expand.grid(A = seq(10, 100, 2), lrc = seq(.5, .8, .025))
       stval <- stval+cbind(runif(dim(stval)[1]),runif(dim(stval)[1])*.01)
        
       llfun<-function(A,lrc)
             -sum((BOD$demand - A*(1-exp(-exp(lrc)*BOD$Time)))^2)
       lls <- NULL 
       for (i in 1:nrow(stval))  {
          lls <- rbind(lls, llfun(stval[i,1], stval[i,2]))
       }
       fm1 <- nls(demand ~ A*(1-exp(-exp(lrc)*Time)),  
                     data = BOD, start = c(A = 20, lrc = log(.35)))
       ss <- -sum(resid(fm1)^2)
       dehaan(lls, ss)
       


###################################################
### chunk number 35: 
###################################################
       llb <- NULL
 for (i in 1:nrow(stval))  {
	llb <- rbind(llb,coef( 
		nls(demand ~ A*(1-exp(-exp(lrc)*Time)),  
                     data = BOD, start = c(A=stval[i,1], lrc = stval[i,2])
		)
		))
 }    
    starr(llb)
    


###################################################
### chunk number 36: 
###################################################
     # an example with a singular matrix
     S <- matrix(c(2,0,2.5,0,2,0,2.5,0,3),ncol=3)
     sechol(S) 


###################################################
### chunk number 37: 
###################################################
# Cholesky 1, Invertible
S <- matrix(c(2,0,2.4,0,2,0,2.4,0,3),ncol=3)
print(try(chol(S)))
sechol.out <- sechol(S)
t(sechol.out) %*% sechol.out


###################################################
### chunk number 38: 
###################################################
# Cholesky 3, Ill-Conditioned
S <- matrix(c(2,0,10,0,2,0,10,0,3),ncol=3)
print(try(chol(S)))
sechol.out<- sechol(S)
t(sechol.out) %*% sechol.out


###################################################
### chunk number 39: 
###################################################
X <- matrix(c(
  10 ,   30 ,   25 ,   55 ,   50 ,   40 ,   30 ,   15 ,
   5 ,   30 ,   15 ,   10 ,   17 ,   15 ,   15 ,   22 ,
5002 , 5000 , 5000 , 5000 , 5000 , 5000 , 5000 , 5000 ,
  21 ,   22 ,   22 ,   22 ,   22 ,   22 ,   22 ,   21 ,
  20 ,   20 ,   21 ,   22 ,   18 ,   20 ,   24 ,   18 ),
nrow=5,byrow=TRUE)
X.mat <- cbind(rep(1,nrow(t(X))),t(X))
dimnames(X.mat)[[2]] <- c("Constant","Percent Low Income","Mean Teacher Experience", "Per-Pupil Spending",
                        "Percent Minority Teachers","Class Size")
Y.vec <- c(1,0,0,0,1,1,0,1)


###################################################
### chunk number 40: 
###################################################
glm(Y.vec ~ X.mat[,-1], family=binomial(link = "probit"))


###################################################
### chunk number 41: 
###################################################
probit.log.like <- function(beta,X,Y)  {
         - sum( log(1-pnorm(X%*%beta))*(1-Y) ) - sum(log(pnorm(X%*%beta))*Y )
}

dd.log.like <- function(beta,X,Y)  {
        lambda.0 <- (1-Y)*(-1*dnorm(X%*%beta)/(1-pnorm(X%*%beta)))
        lambda.1 <- Y*dnorm(X%*%beta)/(pnorm(X%*%beta))
        ( -sum( lambda.0*(lambda.0 + X%*%beta)*(1-Y)  )*t(X)%*%X -
        sum( lambda.1*(lambda.1 + X%*%beta)*(Y) )*t(X)%*%X )
}

star.prob <- optim(fn=probit.log.like,par=rep(0,ncol(X.mat)),X=X.mat,Y=Y.vec)
star.pars=star.prob$par; names(star.pars)=dimnames(X.mat)[[2]]
star.pars


###################################################
### chunk number 42: 
###################################################
star.hess <- dd.log.like(star.prob$par,X.mat,Y.vec)
matrix(star.hess, nrow=6)
strsplit(try(solve(star.hess)),":")


###################################################
### chunk number 43: 
###################################################
library("MASS")
star.vc <- ginv(-star.hess)
strsplit(try(chol(star.vc)),":")


###################################################
### chunk number 44: 
###################################################
round(sechol(star.vc),4)


