afc.mc                  package:afc                  R Documentation

_2_A_F_C _F_o_r _O_r_d_i_n_a_l _P_o_l_y_c_h_o_t_o_m_o_u_s _O_b_s_e_r_v_a_t_i_o_n_s _A_n_d _C_o_n_t_i_n_u_o_u_s
_F_o_r_e_c_a_s_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     Routine to calculate the Generalized Discrimination Score (aka
     Two-Alternatives Forced Choice Score 2AFC) for the situation of
     polychotomous observations (ordinal) and continuous forecasts

_U_s_a_g_e:

     afc.mc(obsv, fcst, m = 3)

_A_r_g_u_m_e_n_t_s:

    obsv: vector with polychotomous observations (values in {1,..,m}) 

    fcst: vector of same length as _obsv_ with real-valued forecasts 

       m: number of observation categories (default = 3) 

_D_e_t_a_i_l_s:

     This routine applies Eq.18 of Mason and Weigel (2009) to calculate
     the 2AFC.

_V_a_l_u_e:

  p.afc : Value of Generalized Discrimination (2AFC) Score 

_A_u_t_h_o_r(_s):

     Andreas Weigel, Federal Office of Meteorology and Climatology,
     MeteoSwiss, Zurich, Switzerland

_R_e_f_e_r_e_n_c_e_s:

     S.J. Mason and A.P. Weigel, 2009. A generic verification framework
     for administrative purposes. Mon. Wea. Rev., 137, 331-349

_S_e_e _A_l_s_o:

     'afc'

_E_x_a_m_p_l_e_s:

       #Forecasts and observations of Nino-3.4 index
       #Load set of polychotomous observations (4 categories) and continuous forecasts
       data(cnrm.nino34.mc)
       obsv = cnrm.nino34.mc$obsv
       fcst = cnrm.nino34.mc$fcst

       #Calculate skill score
       afc.mc(obsv,fcst,4)

