strip.plot             package:agricolae             R Documentation

_S_t_r_i_p-_P_l_o_t _a_n_a_l_y_s_i_s

_D_e_s_c_r_i_p_t_i_o_n:

     The variance analysis of a strip-plot design is divided into three
     parts:  the horizontal-factor analysis, the vertical-factor
     analysis, and the  interaction analysis.

_U_s_a_g_e:

     strip.plot(BLOCKS, COL, ROW, Y)

_A_r_g_u_m_e_n_t_s:

  BLOCKS: replications 

     COL: Factor column 

     ROW: Factor row 

       Y: Variable, response 

_D_e_t_a_i_l_s:

     The strip-plot design is specifically suited for a two-factor
     experiment in which the desired precision for measuring the
     interaction effects between the two factors is higher than that
     for measuring the main efect two factors

_V_a_l_u_e:

  BLOCKS: vector, numeric 

     COL: vector, numeric 

     ROW: vector, numeric 

       Y: vector, numeric 

_A_u_t_h_o_r(_s):

     Felipe de Mendiburu

_R_e_f_e_r_e_n_c_e_s:

     Statistical procedures for agricultural research. Kwanchai A.
     Gomez, Arturo A. Gomez. Second Edition. 1984.

_E_x_a_m_p_l_e_s:

     # Yield
     library(agricolae)
     data(huasahuasi)
     attach(huasahuasi)
     YIELD<-huasahuasi$YIELD
     attach(YIELD)
     market <- y1da + y2da
     non_market <- y3da
     yield <- market + non_market
     model<-strip.plot(block, clon, trt, yield)
     comparison<-LSD.test(yield,clon,model$gl.a,model$Ea)
     comparison<-LSD.test(yield,trt,model$gl.b,model$Eb)
     # simple effects
     out<-by(yield,trt, function(x) LSD.test(x, clon, model$gl.c, model$Ec))
     out

