### Name: LSD.test
### Title: Multiple comparisons, "Least significant difference" and Adjust
###   P-values
### Aliases: LSD.test
### Keywords: htest

### ** Examples

library(agricolae)
data(sweetpotato)
attach(sweetpotato)
model<-aov(yield~virus)
df<-df.residual(model)
MSerror<-deviance(model)/df
comparison <- LSD.test(yield,virus,df,MSerror, p.adj="bonferroni", group=FALSE,
main="Yield of sweetpotato\ndealt with different virus")
detach(sweetpotato)
#stargraph
bar.err(comparison,std=TRUE,ylim=c(0,45),density=4,border="blue")
#endgraph




