### Name: correlation
### Title: Correlation analysis. Methods of Pearson, Spearman and Kendall
### Aliases: correlation
### Keywords: multivariate

### ** Examples

library(agricolae)
# example 1
data(soil)
analysis<-correlation(soil[,2:8],method="pearson")
analysis

# Example 2: correlation between pH, variable 2 and other elements from soil.
data(soil)
attach(soil)
analysis<-correlation(pH,soil[,3:8],method="pearson",alternative="less")
analysis
detach(soil)

# Example 3: correlation between pH and clay method kendall.
data(soil)
attach(soil)
correlation(pH,clay,method="kendall", alternative="two.sided")
detach(soil)



