### Name: waller.test
### Title: Multiple comparisons, Waller-Duncan
### Aliases: waller.test
### Keywords: htest

### ** Examples

library(agricolae)
data(sweetpotato)
attach(sweetpotato)
model<-aov(yield~virus)
df<-df.residual(model)
MSerror<-deviance(model)/df
Fc<-anova(model)[1,4]
comparison <- waller.test(yield, virus, df, MSerror, Fc, group=TRUE, 
main="Yield of sweetpotato. Dealt with different virus")
# std = F (default) is standard error
#startgraph
par(mfrow=c(2,2))
bar.err(comparison,std=TRUE,horiz=TRUE,xlim=c(0,45),density=4)
bar.err(comparison,std=TRUE,horiz=FALSE,ylim=c(0,45),density=8,col="blue")
bar.group(comparison,horiz=FALSE,ylim=c(0,45),density=8,col="red")
bar.group(comparison,horiz=TRUE,xlim=c(0,45),density=4,col="green")
#endgraph



