###################################################
### chunk number 1: graphSettings
###################################################
options(width=60)
#RColorBrewer:::brewer.pal(9,'Set1')
clrs <- c("#E41A1C", "#377EB8", "#4DAF4A", "#984EA3", "#FF7F00", "#FFFF33", 
		"#A65628", "#F781BF", "#999999")

library(lattice)
#from latticeExtra: 
custom.theme <- function (symbol, fill, region,	reference, bg, fg){
	theme <- list(plot.polygon = list(col = fill[1], border = fg[1]), 
			box.rectangle = list(col = symbol[1]), box.umbrella = list(col = symbol[1]), 
			dot.line = list(col = reference), dot.symbol = list(col = symbol[1]), 
			plot.line = list(col = symbol[1]), plot.symbol = list(col = symbol[1]), 
			regions = list(col = colorRampPalette(region)(100)), 
			reference.line = list(col = reference), superpose.line = list(col = symbol), 
			superpose.symbol = list(col = symbol), superpose.polygon = list(col = fill, 
					border = fg), background = list(col = bg), add.line = list(col = fg), 
			add.text = list(col = fg), box.dot = list(col = fg), 
			axis.line = list(col = fg), axis.text = list(col = fg), 
			strip.border = list(col = fg), box.3d = list(col = fg), 
			par.xlab.text = list(col = fg), par.ylab.text = list(col = fg), 
			par.zlab.text = list(col = fg), par.main.text = list(col = fg), 
			par.sub.text = list(col = fg))
	modifyList(standard.theme("pdf"), theme)
}

options(digits=3, width=70)

mylattice <- custom.theme(symbol = clrs,
		fill =clrs,
		region =clrs,
		reference = 'darkgrey',
		bg = "transparent", fg = "black")

mylattice$add.text$cex <- .5

mylattice$strip.background$col <- "transparent"
mylattice$strip.shingle <- list(alpha=.75, col=clrs)

mylattice$box.rectangle$fill <- 'lightgrey'
mylattice$box.rectangle$col <- 'black'
mylattice$box.rectangle$lwd <- .3

mylattice$box.umbrella$col <- 'black'
mylattice$box.umbrella$lwd <- .6
mylattice$box.umbrella$lty <- 1
mylattice$box.umbrella$lty <- 1

mylattice$box.dot$cex <- 2
mylattice$box.dot$pch <- '|'
mylattice$box.dot$col <- '#E41A1C'

#new <- lattice.options(default.theme=mylattice)
trellis.par.set(theme=mylattice)

palette(clrs)
#show.settings()


###################################################
### chunk number 2: loadLibs
###################################################
#library(lme4)	
#sourceDir <- function(path, trace = TRUE, ...) {
#	for (nm in list.files(path, pattern = "\\.[RrSsQq]$")) {
#		if(trace) cat(nm,":")           
#		source(file.path(path, nm), ...)
#		if(trace) cat("\n")
#	}
#}
#sourceDir("F:\\lme4Spline\\amer\\R")
library(amer)


###################################################
### chunk number 3: unionData
###################################################
#source("F:\\lme4Spline\\amer\\data\\union.r")
data(union)


###################################################
### chunk number 4: unionFit
###################################################
#dataset(union)
u1 <- amer(UNION ~ tp(WAGE), family = binomial, data = union)


###################################################
### chunk number 5: unionFit2
###################################################
K <- 15
degree <- 1
knots <- quantile(union$WAGE, probs = (2:(K - degree + 1))/(K - degree + 2))
u2 <- amer(UNION ~ tp(WAGE, knots = knots), family = binomial, data = union)


###################################################
### chunk number 6: printUnionFit
###################################################
print(u2, corr=F)


###################################################
### chunk number 7: unionPlot
###################################################
par(mfrow=c(1,2))                 
plotF(u1, trans=plogis, rug=F, ylim=c(0,.4), auto.layout=F)
with(union, points(WAGE, jitter(.4*UNION, factor=0.15), cex=.5))
plotF(u2, trans=plogis, rug=F, ylim=c(0,.4), auto.layout=F)
with(union, points(WAGE, jitter(.4*UNION, factor=0.15), cex=.5))


###################################################
### chunk number 8: dogFitBy
###################################################
#source("F:\\lme4Spline\\amer\\data\\dog.r")
data(dog)                
d1 <- amer(y ~ -1 + group + tp(time, by = group) + (1|dog), data=dog)


###################################################
### chunk number 9: printDogFitBy
###################################################
print(d1, corr=F)


###################################################
### chunk number 10: dogPlot
###################################################
print(xyplot(y~time|group, groups=dog, data=dog, type="b", col=1))


###################################################
### chunk number 11: dogPlotBy
###################################################
layout(cbind(matrix(1, ncol=2, nrow=2), matrix(2:5, ncol=2, nrow=2)))                   
par(mar=c(3.0, 2.8, 2.8, 0.8), mgp = c(2,1,0))
plotF(d1, ylim = range(dog$y), interval="none", 
		legend="topleft", level=.95, auto.layout=F, lwd=3)
d1.RW <- getF(d1, interval="RW")
for(i in 1:4){
	plot(0, 0, ylim= range(dog$y), xlim=c(0,1), ylab="y", xlab="time")
	sub <- subset(dog, group==i)
	lapply(split(sub, sub$dog, drop=T), function(x) lines(x$time, x$y, col="lightgrey", lty=2, lwd=.5))
	matlines(d1.RW[[1]][[i]][,1], d1.RW[[1]][[i]][,-1],	 type="l", lty=c(1,3,3), col=i, lwd=2.5)
}


###################################################
### chunk number 12: dogFitAllP
###################################################
d2 <- amer(y ~ -1+ group + tp(time, k=5, by=dog, allPen=T) + tp(time, by=group), data=dog)	


###################################################
### chunk number 13: printDogFitAllP
###################################################
print(d2, corr=F)


###################################################
### chunk number 14: dogFitAllPDiag
###################################################
d3 <- amer(y ~ -1+ group + tp(time, k=5, by=dog, allPen=T, diag=T) + tp(time, k=5, by=group), data=dog)


###################################################
### chunk number 15: printDogFitAllPDiag
###################################################
print(d3, corr=F)


###################################################
### chunk number 16: ethanolPlot
###################################################
data(ethanol)                   
print(xyplot(NOx ~ C|equal.count(E,6), data=ethanol, type=c("p","r")))	            


###################################################
### chunk number 17: ethanolFit
###################################################
e1 <- amer(NOx ~ tp(E, k=20) + tp(E, k=20, varying=C), data=ethanol)


###################################################
### chunk number 18: printEthanolFit
###################################################
print(e1, corr=F)


###################################################
### chunk number 19: ethanolCIs
###################################################
par(mfrow=c(2,2), mar=c(3.0, 2.8, 2.8, 0.8), mgp = c(2,1,0))
e1.RW <- plotF(e1, addConst=c(T,F), level=.95, auto.layout=F)
#set.seed(43212345)
set.seed(12345)
e1.MCMC <- plotF(e1, addConst=c(T,F), int="MCMC", sims=1000, level=.95, auto.layout=F)


###################################################
### chunk number 20: ethanolMCMC
###################################################
e1.MCMCData<- as.data.frame(attr(e1.MCMC,"mcmc"))
data.frame(c(fixef(e1), e1@ST, lme4:::sigma(e1)))
apply(e1.MCMCData, 2, quantile, probs=c(.1, .25 ,.5, .75, .9), na.rm=T)


###################################################
### chunk number 21: ethanolMCMC
###################################################
print(xyplot(attr(e1.MCMC,"mcmc")))


###################################################
### chunk number 22: tpU
###################################################
tp2 <- function(x, p = 2, k = 15, dimU = 1, by = NULL, 
		allPen = FALSE, diag = FALSE, varying = NULL, 
		knots = quantile(x, 
			probs = (2:(k - p + 1))/(k - p + 2)))
{
	#dim. of nullspace can't be larger than p of TP-basis:
	stopifnot(dimU <= p)
	
	#always need this for the call attribute of the returned value:
	call <- as.list(expand.call())
	call$knots <- knots
	
	#global polynomial trends (no intercept!):
	X <- if (p > 0) {
				outer(x, 1:p, "^")
			} else {
				matrix(nrow = length(x), ncol = 0)
			} 
	
	#TP-design for penalised part:
	Z <- outer(x, knots, "-")^p * outer(x, knots, ">")
	
	# adapt design for dimU option:
	if (dimU != p) {
		Xp <- X[, (1:p) > dimU, drop = F]
		X <- X[, (1:p) <= dimU, drop = F]
		Z <- cbind(Xp, Z)
	}
	
	res <- list(X = X, Z = Z)
	attr(res, "call") <- as.call(call)
	return(res)
} 


###################################################
### chunk number 23: dogsTPU
###################################################
d4 <- amer(y ~ -1 + group + tp2(time, k=5, p=2, dimU=1, by = group) + (1|dog), data=dog, basisGenerators=c("tp2"))


###################################################
### chunk number 24: printunionTPU
###################################################
print(d4, corr=F)


###################################################
### chunk number 25: compareTPTPU
###################################################
d1.k5 <- amer(y ~ -1 + group + tp(time, k=5, by = group) + (1|dog), data=dog)                   
par(mfrow=c(1,2))
plotF(d1.k5, legend="topleft", auto.layout=F)
plotF(d4, legend="none", auto.layout=F)


