###################################################
### chunk number 1: 
###################################################
frogdat <- data.frame(
  size=rep(c(9,12,21,25,37),each=3),
  killed=c(0,2,1,3,4,5,rep(0,4),1,rep(0,4)))
frogdat$initial <- rep(10,nrow(frogdat))


###################################################
### chunk number 2: 
###################################################
library(bbmle)
library(ggplot2)
print(gg1 <- ggplot(frogdat,aes(x=size,y=killed))+geom_point()+
      stat_sum(aes(size=factor(..n..)))+
      labs(size="#")+scale_x_continuous(limits=c(0,40)))
m1 <- mle2(killed~dbinom(prob=c*(size/d)^g*exp(1-size/d),
  size=initial),data=frogdat,start=list(c=0.5,d=5,g=1))
pdat <- data.frame(size=1:40,initial=rep(10,40))
pdat1 <- data.frame(pdat,killed=predict(m1,newdata=pdat))
m2 <- mle2(killed~dbinom(prob=c*((size/d)*exp(1-size/d))^g,
  size=initial),data=frogdat,start=list(c=0.5,d=5,g=1))
pdat2 <- data.frame(pdat,killed=predict(m2,newdata=pdat))
gg1 + geom_line(data=pdat1,colour="red")+geom_line(data=pdat2,colour="blue")


###################################################
### chunk number 3: 
###################################################
coef(m2)
prof2 <- profile(m2)


###################################################
### chunk number 4: 
###################################################
print(plot(prof2))


###################################################
### chunk number 5: 
###################################################
prof2_df <- as.data.frame(prof2)
library(lattice)
print(xyplot(abs(z)~focal|param,data=prof2_df,
       subset=abs(z)<3,
       type="b",
       xlab="",
       ylab=expression(paste(abs(z),
           " (square root of ",Delta," deviance)")),
       scale=list(x=list(relation="free"))))


###################################################
### chunk number 6: 
###################################################
print(ggplot(subset(prof2_df,abs(z)<3),
       aes(x=focal,y=abs(z)))+geom_line()+
      facet_wrap(~param,scale="free_x"))


