### Name: SampleStatistics
### Title: SampleStatistics
### Aliases: SampleStatistics
### Keywords: univar

### ** Examples

 data(BodySatisfaction)

 ## Table 2.6 in Bergsma, Croon and Hagenaars (2009). Loglinear parameters for marginal table IS
 ## We provide two to obtain the parameters

 dat   <- BodySatisfaction[,2:8]        # omit first column corresponding to gender

 # matrix producing 1-way marginals, ie the 7x5 table IS
 at75 <- MarginalMatrix( c(1, 2, 3, 4, 5, 6, 7), list(c(1),c(2),c(3),c(4),c(5),c(6),c(7)), c(5, 5, 5, 5, 5, 5, 5) )

 # First method: the "coefficients" are the log-probabilities, from which all the (loglinear) parameters are calculated
 SampleStatistics(dat, list("log",at75), CoefficientDimensions=c(7,5),Labels=c("I","S"),ShowCoefficients=FALSE,ShowParameters=TRUE)

 # Second method: the "coefficients" are explicitly specified as being the (highest-order) loglinear parameters
 loglinpar75 <- SpecifyCoefficient("LoglinearParameters", c(7,5) )
 SampleStatistics(dat, list(loglinpar75, at75), CoefficientDimensions=c(7,5), Labels=c("I","S"))



