spec.ls                 package:cts                 R Documentation

_E_s_t_i_m_a_t_e _S_p_e_c_t_r_a_l _D_e_n_s_i_t_y _o_f _a_n _I_r_r_e_g_u_l_a_r_l_y _S_a_m_p_l_e_d _T_i_m_e _S_e_r_i_e_s _b_y _a _S_m_o_o_t_h_e_d
_P_e_r_i_o_d_o_g_r_a_m

_D_e_s_c_r_i_p_t_i_o_n:

     The most commonly used method of computing the spectrum on
     unevenly spaced time series is periodogram analysis, see Lomb
     (1975) and Scargle (1982). The Lomb-Scargle method for unevenly
     spaced data is known to be a powerful tool to find, and test
     significance of, weak perriodic signals. The Lomb-Scargle
     periodogram possesses the same statistical properties of standard
     power spectra.

_U_s_a_g_e:

     spec.ls(x, y=NULL, spans = NULL, kernel = NULL, taper = 0.1, pad = 0,
     fast = TRUE, type = "lomb",demean = FALSE, detrend = TRUE, plot = TRUE,
     na.action = na.fail, ...)

_A_r_g_u_m_e_n_t_s:

       x: two column data frame or matrix with the first column being
          the sampled time and the second column being the observations
          at the first column; otherwise 'x' is a numeric vector of
          sampled time.

       y: not used if 'x' has two columns; otherwise 'y' is a numeric
          vector of observations at sampled time 'x'.the time at which
          'x' is observed

   spans: vector of odd integers giving the widths of modified Daniell
          smoothers to be used to smooth the periodogram.

  kernel: alternatively, a kernel smoother of class '"tskernel"'.

   taper: proportion of data to taper.  A split cosine bell taper is
          applied to this proportion of the data at the beginning and
          end of the series.

     pad: proportion of data to pad. Zeros are added to the end of the
          series to increase its length by the proportion 'pad'.

    fast: logical; if 'TRUE', pad the series to a highly composite
          length.

    type: Lomb-Scargle spectrum of Fourier transformation spectrum

  demean: logical. If 'TRUE', subtract the mean of the series.

 detrend: logical. If 'TRUE', remove a linear trend from the series.
          This will also remove the mean.

    plot: plot the periodogram?

na.action: 'NA' action function.

     ...: graphical arguments passed to 'plot.spec.ls'.

_D_e_t_a_i_l_s:

     The raw Lomb-Scargle periodogram for irregularly sampled time
     series is not a consistent estimator of the spectral density, but
     adjacent values are asymptotically independent. Hence a consistent
     estimator can be derived by smoothing the raw periodogram,
     assuming that the spectral density is smooth.

     The series will be automatically padded with zeros until the
     series length is a highly composite number in order to help the
     Fast Fourier Transform. This is controlled by the 'fast' and not
     the 'pad' argument.

     The periodogram at zero is in theory zero as the mean of the
     series is removed (but this may be affected by tapering): it is
     replaced by an interpolation of adjacent values during smoothing,
     and no value is returned for that frequency.

_V_a_l_u_e:

     A list object of class '"spec.ls"' with the following additional
     components: 

  kernel: The 'kernel' argument, or the kernel constructed from
          'spans'.

      df: The distribution of the spectral density estimate can be
          approximated by a chi square distribution with 'df' degrees
          of freedom.

bandwidth: The equivalent bandwidth of the kernel smoother as defined
          by Bloomfield (1976, page 201).

   taper: The value of the 'taper' argument.

     pad: The value of the 'pad' argument.

 detrend: The value of the 'detrend' argument.

  demean: The value of the 'demean' argument.


     The result is returned invisibly if 'plot' is true.

_N_o_t_e:

     This is 'slow' program and a fast program may use FFT, see (Press
     et al, 1992)

_A_u_t_h_o_r(_s):

     Lomb-Scargle periodogram by Zhu Wang

_R_e_f_e_r_e_n_c_e_s:

     Bloomfield, P. (1976) _Fourier Analysis of Time Series: An
     Introduction._Wiley.

     Lomb, N. R. (1976) Least-squares frequency-analysis of unequally
     spaced data. _Astrophysics and Space Science_, *39*,447-462

     W. H. Press and S. A. Teukolsky and W. T. Vetterling and B.P.
     Flannery (1992) _Numerical Recipes in C: The Art of Scientific
     Computing._, Cambridge University Press, second edition.

     Scargle, J.D. (1982) Studies in astronomical time series analysis
     II. Statistical aspects of spectral analysis of unevenly spaced
     data, _The Astrophysical Journal_, *263*, volume 2, 835-853.

_S_e_e _A_l_s_o:

     'spec.taper', 'plot.spec.ls', 'fft'

_E_x_a_m_p_l_e_s:

     ## Not run: 
     data(V22174)
     spec.ls(V22174)

     data(asth)
     spec.ls(asth)
     ## End(Not run)

