### Name: fit
### Title: Fit 'depmix' or 'mix' models
### Aliases: fit depmix.fit fit,depmix-method show,depmix.fitted-method
###   summary,depmix.fitted-method mix.fit fit,mix-method
###   show,mix.fitted-method summary,mix.fitted-method
### Keywords: methods

### ** Examples


data(speed)

# 2-state model on rt and corr from speed data set with Pacc as covariate on the transition matrix
# starting values for the transition pars (without those EM does not get off the ground)
set.seed(1)
tr=runif(6)
trst=c(tr[1:2],0,tr[3:5],0,tr[6])
mod1 <- depmix(list(rt~1,corr~1),data=speed,transition=~Pacc,nstates=2,family=list(gaussian(),multinomial()),
        trstart=trst)
# fit the model
fmod1 <- fit(mod1)
fmod1 # to see the logLik and optimization information
# to see the parameters
summary(fmod1)

## Not run: 
##D # NOTE: this requires Rdonlp2 package to be installed
##D 
##D # FIX SOME PARAMETERS
##D 
##D # get the starting values of this model to the optimized 
##D # values of the previously fitted model to speed optimization
##D 
##D pars <- c(unlist(getpars(fmod1)))
##D 
##D # constrain the initial state probs to be 0 and 1 
##D # also constrain the guessing probs to be 0.5 and 0.5 
##D # (ie the probabilities of corr in state 1)
##D # change the ones that we want to constrain
##D pars[2]=+Inf # this means the process will always start in state 2
##D pars[14]=0 # the corr parameters in state 1 are now both 0, corresponding the 0.5 prob
##D mod2 <- setpars(mod1,pars)
##D 
##D # fix the parameters by setting: 
##D free <- c(0,0,rep(c(0,1),4),1,1,0,0,1,1,0,1)
##D # fit the model
##D fmod2 <- fit(mod2,fixed=!free)
##D 
##D # likelihood ratio insignificant, hence fmod2 better than fmod1
##D llratio(fmod1,fmod2)
##D 
##D # NOW ADD SOME GENERAL LINEAR CONSTRAINTS
##D 
##D # set the starting values of this model to the optimized 
##D # values of the previously fitted model to speed optimization
##D 
##D pars <- c(unlist(getpars(fmod2)))
##D mod3 <- setpars(mod2,pars)
##D 
##D # start with fixed and free parameters
##D conpat <- c(0,0,rep(c(0,1),4),1,1,0,0,1,1,0,1)
##D # constrain the beta's on the transition parameters to be equal
##D conpat[4] <- conpat[8] <- 2
##D conpat[6] <- conpat[10] <- 3
##D 
##D fmod3 <- fit(mod3,equal=conpat)
##D 
##D llratio(fmod2,fmod3)
##D 
##D # above constraints can also be specified using the conrows argument as follows
##D conr <- matrix(0,2,18)
##D # pars 4 and 8 have to be equal, otherwise stated, their diffence should be zero
##D conr[1,4] <- 1
##D conr[1,8] <- -1
##D conr[2,6] <- 1
##D conr[2,10] <- -1
##D 
##D # note here that we use the fitted model fmod2 as that has appropriate 
##D # starting values
##D fmod3b <- fit(fmod2,conrows=conr,fixed=!free) # using free defined above
##D 
## End(Not run)

data(balance)
# four binary items on the balance scale task

instart=c(0.5,0.5)
set.seed(1)
respstart=runif(16)
# note that ntimes argument is used to make this a mixture model
mod4 <- mix(list(d1~1,d2~1,d3~1,d4~1), data=balance, nstates=2,
        family=list(multinomial(),multinomial(),multinomial(),multinomial()),
        respstart=respstart,instart=instart)

fmod4 <- fit(mod4)

# add age as covariate on class membership by using the prior argument
instart=c(0.5,0.5,0,0) # we need the initial probs and the coefficients of age 
set.seed(2)
respstart=runif(16)
mod5 <- mix(list(d1~1,d2~1,d3~1,d4~1), data=balance, nstates=2,
        family=list(multinomial(),multinomial(),multinomial(),multinomial()),
        instart=instart, respstart=respstart, prior=~age, initdata=balance)

fmod5 <- fit(mod5)

# check the likelihood ratio; adding age significantly improves the goodness-of-fit
llratio(fmod5,fmod4)




