### Name: depmix
### Title: Dependent Mixture Model Specifiction: the long way
### Aliases: makeDepmix
### Keywords: methods

### ** Examples


# below example recreates the model from the depmix help page albeit in a
# roundabout way

data(speed)   

rModels <- list(
        list(
                GLMresponse(formula=rt~1,data=speed,family=gaussian(),pstart=c(5.52,.202)),
                GLMresponse(formula=corr~1,data=speed,family=multinomial(),pstart=c(0.5,0.5))
        ),
        list(
                GLMresponse(formula=rt~1,data=speed,family=gaussian(),pstart=c(6.39,.24)),
                GLMresponse(formula=corr~1,data=speed,family=multinomial(),pstart=c(.1,.9))
        )
)

trstart=c(0.9,0.1,0.1,0.9)

transition <- list()
transition[[1]] <- transInit(~1,nstates=2,data=data.frame(1),pstart=c(trstart[1:2]))
transition[[2]] <- transInit(~1,nstates=2,data=data.frame(1),pstart=c(trstart[3:4]))

instart=c(0,1)
inMod <- transInit(~1,ns=2,ps=instart,data=data.frame(rep(1,3)))

mod <- makeDepmix(response=rModels,transition=transition,prior=inMod,ntimes=attr(speed,"ntimes"))

logLik(mod)

fm <- fit(mod)

fm 

summary(fm)




