### Name: SI
### Title: Comparing selectivity indices across curves
### Aliases: SI relpot
### Keywords: models nonlinear

### ** Examples


m1 <- drm(SLOPE~DOSE, CURVE, data = spinach, fct = LL.4())

SI(m1, c(50,50))
SI(m1, c(10,50))
SI(m1, c(10,50), reverse = TRUE)

## Relative potency of two herbicides
m2 <- drm(DryMatter~Dose, Herbicide, 
data = S.alba, fct = LL.3())

SI(m2, c(50, 50))  
SI(m2, c(50, 50), ci = "delta")
SI(m2, c(50, 50), ci = "fieller")

## Comparison based on absolute
##  response level

m3 <- drm(SLOPE~DOSE, CURVE,
data = spinach, fct = LL.4())

SI(m3, c(0.5,0.5), c(2,4), type="a", ci="fieller")

SI(m3, c(55,80), c(2,4))  
# same comparison using a relative response level

## Relative potency transformed from log scale
m4 <- drm(drymatter~log(dose), treatment, data=G.aparine[-c(1:40), ], 
pmodels = data.frame(treatment,treatment,1,treatment), fct = LL2.4())

SI(m4, c(50,50), ci="fls", logBase=exp(1))




