### Name: mixdrc
### Title: Fitting multiple dose-response curves with random effects
### Aliases: mixdrc
### Keywords: models nonlinear

### ** Examples


## First fitting a model without random effects
## Oops: ideally a Box-Cox transformation should be used
spinach.m1 <- drm(SLOPE~DOSE, CURVE, data = spinach, fct = LL.4(),
pmodels = data.frame(HERBICIDE, 1, 1, HERBICIDE))

## Then fitting the same model (the same fixed effects)
##  but with random effects (assigned to d)

spinach.m2 <- mixdrc(spinach.m1, random="d~1|CURVE", data = spinach)
compParm(spinach.m2, "e", "-")

## Fitting a model without random effects
##  but with a Box-Cox transformation

spinach.m3 <- drm(SLOPE~DOSE, CURVE, data = spinach, fct = LL.4(),
pmodels = data.frame(HERBICIDE, 1, 1, HERBICIDE))

## Then fitting the same model with random effects assigned to d

spinach.m4 <- mixdrc(spinach.m3, random="d~1|CURVE", data = spinach)
compParm(spinach.m4, "e", "-")

## Fitting a model without random effects, but fixing the c parameter at 0
spinach.m5 <- drm(SLOPE~DOSE, CURVE, data = spinach, fct = LL.3(),
pmodels = data.frame(HERBICIDE, 1, HERBICIDE))

## Fitting the corresponding mixed model with random effects on d
spinach.m6 <- mixdrc(spinach.m5, random="d~1|CURVE", data = spinach)




