### Name: mselect
### Title: Model selection
### Aliases: mselect
### Keywords: models nonlinear

### ** Examples


### Example with continuous data
## Fitting initial four-parameter log-logistic model
ryegrass.m1 <- drm(rootl ~ conc, data = ryegrass, fct = LL.4())

## Model selection
mselect(ryegrass.m1, list(LL.3(), LL.5(), W1.3(), W1.4(), W2.4(), baro5()))

mselect(ryegrass.m1, list(LL.5()), nested = TRUE)  # nested models

### Example with quantal data
## Fitting initial two-parameter log-logistic model
earthworms.m1 <- drm(number/total~dose, weights=total, 
data = earthworms, fct = LL.2(), type = "binomial")

## Comparing 4 models
mselect(earthworms.m1, list(W1.2(), W2.2(), LL.3()))
# model selection based AIC or p value not working in this example!!!




