### Name: depratio
### Title: Empirical estimates of the dependence ratios
### Aliases: depratio print.depratio plot.depratio
### Keywords: arith

### ** Examples

## calculate and plot the observed 2nd order dependence ratios
## for the marijuana data:
data(marijuana)
dr.male <- depratio(y~cluster(id)+Time(age), data=marijuana,
                    subset=sex=="male")
dr.male
plot(dr.male)

## confirm that the 1st order Markov assumption is adequate
## for the madras data:
data(madras)

dr2 <- depratio(symptom~cluster(id)+Time(month), data=madras)
dr3 <- depratio(symptom~cluster(id)+Time(month), ord=3, data=madras)
dr <- rbind(dr2$tau[-length(dr2$tau)]*dr2$tau[-1], dr3$tau)

matplot(1:ncol(dr), t(dr))




