### Name: drm
### Title: Combined regression and association models for clustered
###   categorical responses
### Aliases: drm print.drm summary.drm print.summary.drm
### Keywords: models

### ** Examples

######################################################
## Examples for binary responses
###########################################
## Wheeze among Steubenville (see [3]):
## Latent Beta-distributed propensity
data(wheeze)
fit1 <- drm(wheeze~I(age>9)+smoking+cluster(id),data=wheeze,dep="B", print=0)

## Obesity among Muscatine children (see [2]):
## Analysis for completers: M2 for girls
data(obese)
fit2 <- drm(obese~age+cluster(id)+Time(year), subset=sex=="female",
            dep="M2",data=obese)

## Not run: 
##D ## Muscatine children continued (see [3]):
##D ## LM for boys and girls separately
##D fit3 <- drm(obese~age+cluster(id)+Time(age), subset=sex=="male",
##D             dep="LM",data=obese)
##D 
##D fit4 <- drm(obese~age+cluster(id)+Time(age), subset=sex=="female",
##D             dep="LM",data=obese)
## End(Not run)
############################################
## Examples for ordinal responses
############################################
## Movie critic example (see [6]):
## Latent Dirichlet propensities with baseline category link.
data(movie)

options(contrasts=c("contr.treatment","contr.treatment"))
fit5 <- drm(y~critic+cluster(movie), data=movie, dep="D", link="bcl")

## Longitudinal dataset on teenage marijuana use (see [6]):
## Superposition of structures N, L and M for the girls.
data(marijuana)

fit6 <- drm(y~age+cluster(id)+Time(age), data=marijuana,
            subset=sex=="female", dep=list("NLM", ~kappa1==1,
            ~kappa2==0, ~tau12==1, ~tau21==1, ~tau11==tau22))

## Parameter restrictions with functions using M-structure for the boys.
## Plot the second order dependence ratios:
plot(depratio(y~cluster(id)+Time(age), data=marijuana,
     subset=sex=="male"))

## fit the model in [6]:
fit7 <- drm(y~age+cluster(id)+Time(age), data=marijuana,
            subset=sex=="male", dep=list("M", 
            tau12~function(a=1,b=0) a+b*c(0:3),
            tau21~function(a=1,b=0) a+b*c(0:3)))

## Not run: 
##D ##############################################
##D ## Covariates for the association (see [7]):
##D ##############################################
##D data(madras)
##D 
##D ## plot empirical 2nd order dependence ratios with bootstrap CI's
##D tau.madras <- depratio(symptom~cluster(id)+Time(month), data=madras,
##D                        boot.ci = TRUE, n.boot = 1000)
##D plot(tau.madras, log="y", ylim=c(1,40), plot.ci=TRUE)
##D 
##D ## create matrix for profiles:
##D W.madras <- profiles.drm(n.categories=2, n.repetitions=12, "M")
##D 
##D ## create four-level covariate, combining age and sex:
##D madras$age.sex <- factor(paste(madras$age,madras$sex,sep="."))
##D 
##D ## fit the model in [7], Section 4:
##D fit8 <- drm(symptom~age+sex+month+month:age+month:sex+cluster(id)+Time(month),
##D             data=madras, Ncond=FALSE, save.profiles=FALSE, pmatrix="W.madras",
##D             dep=list("NM",nu~nu:age.sex,
##D                      tau~function(a0=0,a1=0) 1+a0*exp(a1*c(0:10))), print=2)
##D 
##D ###################################################
##D ## Dropout model on top of regression & association 
##D ###################################################
##D ## Continue with the madras data.
##D ## fit a model without the dropout model:
##D fit9 <- drm(symptom~age+sex+month+month:age+month:sex+cluster(id)+Time(month),
##D             data=madras, save.profiles=FALSE, pmatrix="W.madras", print=0,
##D             dep=list("NM", tau~function(a0=0,a1=0) 1+a0*exp(a1*c(0:10))))
##D 
##D ## A dropout model assuming MCAR for the thought disorders:
##D 
##D mcar <- drm(symptom~age+sex+month+month:age+month:sex+cluster(id)+Time(month),
##D             data=madras, save.profiles=FALSE, pmatrix="W.madras",
##D             dep=list("NM", tau~function(a0=0,a1=0) 1+a0*exp(a1*c(0:10)),
##D                      ~symptom.cur==0,~symptom.prev==0),
##D             dropout=TRUE, start=c(coef(fit9), -4))
##D 
##D ## A dropout model assuming MAR; including sex as a covariate:
##D 
##D mar <- drm(symptom~age+sex+month+month:age+month:sex+cluster(id)+Time(month),
##D            data=madras, save.profiles=FALSE, pmatrix="W.madras",
##D            dep=list("NM", tau~function(a0=0,a1=0) 1+a0*exp(a1*c(0:10)),
##D                     ~symptom.cur==0), dropout=TRUE, drop.x=sex,
##D            start=c(coef(mcar),0,0))
##D 
##D ## A dropout model assuming MNAR and sex as a covariate:
##D 
##D mnar <- drm(symptom~age+sex+month+month:age+month:sex+cluster(id)+Time(month),
##D             data=madras, save.profiles=FALSE, pmatrix="W.madras",
##D             dep=list("NM", tau~function(a0=0,a1=0) 1+a0*exp(a1*c(0:10))),
##D             dropout=TRUE, drop.x=sex, start=c(coef(mcar),0,0,0))
##D 
##D ## print out coefficients and std.errors:
##D coef(summary(mnar))
## End(Not run)
## std.error of `symptom.cur' all over the place; too few dropouts
## for a comprehensive evaluation of the dropout mechanism



