### Name: getass.drm
### Title: Support function for drm: specification of the association model
### Aliases: getass.drm
### Keywords: utilities

### ** Examples

### Example of functional forms:
## non-stationary second order Markov structure
## initial values of the dependence ratios are set to 1.
## Not run: 
##D data(wheeze)
##D assoc <- list("M2",
##D               tau12 ~ function(a78=1, a89=1, a910=1)c(a78, a89, a910),
##D               tau123 ~ function(a789=1, a8910=1)c(a789, a8910),
##D               tau13 ~ function(a79=1, a810=1)c(a79, a810))
##D 
##D fit1 <- drm(wheeze~I(age>9)+smoking+cluster(id)+Time(age),
##D             data=wheeze, dep=assoc, print=0)
##D ### Example of other parameter restrictions:
##D ## fixing parameters to a known value: ~tau12==1, ~tau21==1
##D ## setting parameters to equal: ~tau11==tau22
##D data(marijuana)
##D assoc <- list("M", ~tau12==1, ~tau21==1, ~tau11==tau22)
##D 
##D fit2 <- drm(y~age+cluster(id)+Time(age), data=marijuana,
##D             subset=sex=="female", dep=assoc, print=0)
##D 
##D ## setting all parameters to equal:
##D 
##D assoc <- list("M", ~tau11==tau12, ~tau11==tau21, ~tau11==tau22)
##D 
##D fit3 <- drm(y~age+cluster(id)+Time(age), data=marijuana,
##D             subset=sex=="female", dep=assoc, print=0)
## End(Not run)
### Example of covariates for the association parameters:
## allow the probabilities within the latent class
## vary by sex. Note: covariate needs to be a factor.
data(obese)
assoc <- list("L", kappa ~ kappa:factor(sex))

fit4 <- drm(obese~age+cluster(id)+Time(age), data=obese,
            dep=assoc, print=0)

### Example how to derive conditional probabilities from marginals
## Fit a model with three latent classes:
data(wheeze)
latent3 <- drm(wheeze~I(age>9)+smoking+cluster(id),data=wheeze,
               dep="L",Lclass=3, print=0)

## calculate conditional probabilities:
## pr(Y=1|L=2) = pr(Y=1)/(nu2+kappa1*nu1+kappa0*(1-nu1-nu2))
## pr(Y=1|L=1) = kappa1*pr(Y=1|L=2)
## pr(Y=1|L=0) = kappa0*pr(Y=1|L=2)

est <- coef(latent3)
psi2 <- latent3$fitted.marginals/
        (est["nu2"]+est["kappa1"]*est["nu1"]+
         est["kappa0"]*(1-est["nu1"]-est["nu2"]))
psi1 <- psi2*est["kappa1"]
psi0 <- psi2*est["kappa0"]

## check the model validity, i.e. require that 0 < psi_i <1:
range(cbind(psi0,psi1,psi2))




