### Name: profiles.drm
### Title: Creates a support matrix for `drm' for profile probability
###   calculation
### Aliases: profiles.drm
### Keywords: array

### ** Examples

## use marijuana-data
data(marijuana)

## create matrix for profiles:
W.mari <- profiles.drm(3, 5, "M")

## fit the model using W.mari:
fit <- drm(y~age+cluster(id)+Time(age), data=marijuana,
           subset=sex=="male",pmatrix="W.mari", save.profiles=FALSE,
           dep=list("M",tau12~function(a=1,b=0) a+b*c(0:3),
                    tau21~function(a=1,b=0) a+b*c(0:3)),print=0)

## a speedy way of saving the profile probabilities to the object:
fit <- drm(y~age+cluster(id)+Time(age), data=marijuana,
           subset=sex=="male",pmatrix="W.mari", save.profiles=TRUE,
           dep=list("M",tau12~function(a=1,b=0) a+b*c(0:3),
                    tau21~function(a=1,b=0) a+b*c(0:3)),print=0,
           start=coef(fit))




