### Name: Kci
### Title: Test against non-Poisson (in-)homogeneous models
### Aliases: Kci Ki plot.ecespa.kci print.ecespa.kci ecespa.kci
### Keywords: spatial

### ** Examples

 ## Not run: 
##D  
##D     require(spatstat)
##D     data(urkiola)
##D 
##D    #####################
##D    ## univariate example
##D 
##D    # get univariate pp
##D    I.ppp <- split.ppp(urkiola)$birch
##D 
##D    # estimate inhomogeneous intensity function
##D    I.lam <- predict (ppm(I.ppp, ~polynom(x,y,2)), type="trend", ngrid=200)
##D 
##D    # Compute and plot envelopes to Kinhom, simulating from an Inhomogeneous
##D    #  Poisson Process:
##D    
##D    I2.env <- envelope( I.ppp,Kinhom, lambda=I.lam, correction="trans", 
##D                               nsim=99, simulate=expression(rpoispp(I.lam)))
##D    plot(I2.env, sqrt(./pi)-r~r) 
##D 
##D    # It seems that there is short scale clustering; let's fit an Inhomogeneous 
##D    # Poisson Cluster Process: 
##D 
##D    I.ki <- ipc.estK(mippp=I.ppp, lambda=I.lam, correction="trans")
##D 
##D    # Compute and plot envelopes to Kinhom, simulating from the fitted IPCP:
##D 
##D    Ipc.env <- Ki(I.ki, correction="trans", nsim=99, ngrid=200)
##D 
##D    plot (Ipc.env)
##D  
##D    #####################
##D    ## bivariate example: test independence between birch and quercus in Urkiola
##D 
##D    J.ppp <- split.ppp(urkiola)$oak
##D    
##D    # We want to simulate oak from a homogeneous Poisson model:
##D    J.ppm <- ppm(J.ppp, trend=~1, interaction=Poisson() )
##D    
##D    IJ.env <- Kci (mod1=I.ki, nsim=99, mod2=J.ppm)
##D    
##D    plot(IJ.env, type=12)
##D    
##D    plot(IJ.env, type=21)
##D  
##D  
## End(Not run)



