### Name: Kinhom.log
### Title: Simulation envelopes from the fitted values of a logistic model
### Aliases: Kinhom.log
### Keywords: spatial

### ** Examples

 ## Not run: 
##D  
##D    require(spatstat)
##D    
##D    data(quercusvm)
##D 
##D    # read fitted values from logistic model:
##D    
##D    
##D    probquercus <-c(0.99955463, 0.96563477, 0.97577094, 0.97327199, 0.92437309,
##D    0.84023396, 0.94926682, 0.89687281, 0.99377915, 0.74157478, 0.95491518,
##D    0.72366493, 0.66771787, 0.77330148, 0.67569082, 0.9874892, 0.7918891, 
##D    0.73246803, 0.81614635, 0.66446411, 0.80077908, 0.98290508, 0.54641754,
##D    0.53546689, 0.73273626, 0.7347013, 0.65559655, 0.89481468, 0.63946334,
##D    0.62101995, 0.78996371, 0.93179582, 0.80160346, 0.82204428, 0.90050059,
##D    0.83810669, 0.92153079, 0.47872421, 0.24697004, 0.50680935, 0.6297911, 
##D    0.46374812, 0.65672284, 0.87951682, 0.35818237, 0.50932432, 0.92293014,
##D    0.48580241, 0.49692053, 0.52290553, 0.7317549, 0.32445982, 0.30300865,
##D    0.73599359, 0.6206056, 0.85777043, 0.65758613, 0.50100406, 0.31340849, 
##D    0.22289286, 0.40002879, 0.29567678, 0.56917817, 0.56866864, 0.27718552,
##D    0.4910667, 0.47394411, 0.40543788, 0.29571349, 0.30436276, 0.47859015,
##D    0.31754526, 0.42131675, 0.37468782, 0.73271225, 0.26786274, 0.59506388, 
##D    0.54801851, 0.38983575, 0.64896835, 0.37282031, 0.67624306, 0.29429766,
##D    0.29197755, 0.2247629, 0.40697843, 0.17022391, 0.26528042, 0.24373722,
##D    0.26936163, 0.13052254, 0.19958585, 0.18659692, 0.36686678, 0.47263005,
##D    0.39557661, 0.68048997, 0.74878567, 0.88352322, 0.93851375)
##D    
##D   
##D 
##D    ################################ 
##D    ## Envelopes for an homogeneous point pattern:
##D    
##D    cosap <- Kinhom.log(A=quercusvm, lifemark="0", nsim=99, prob=probquercus)
##D 
##D    plot(cosap)
##D 
##D    
##D    ################################ 
##D    ## Envelopes for an inhomogeneous point pattern:
##D    
##D    ## First, fit an inhomogeneous Poisson model to alive trees :
##D    
##D    quercusalive <- unmark(quercusvm[quercusvm$marks == 0])
##D 
##D     mod2 <- ppm(quercusalive, ~polynom(x,y,2))
##D 
##D     ## Now use mod2 to estimate lambda for K.inhom:
##D     
##D     cosapm <- Kinhom.log(A=quercusvm, lifemark="0", prob=probquercus, 
##D                                    nsim=99, mod=mod2)
##D 
##D    
##D    ################################ 
##D    ## An example of homogeneous random thinning:
##D       
##D    cosa <- Kinhom.log(A=quercusvm, lifemark="0")
##D    
##D    plot(cosa)
##D     
##D     
##D  
## End(Not run)



