### Encoding: latin1

### Name: Kmm
### Title: Mark-weighted K-function
### Aliases: Kmm plot.ecespa.kmm print.ecespa.kmm ecespa.kmm
### Keywords: spatial

### ** Examples

  ## Not run: 
##D   ## Figure 3.10 of De la Cruz (2008):
##D   
##D   data(seedlings1)
##D   
##D   data(seedlings2)
##D   
##D   s1km <- Kmm(seedlings1, r=1:100)
##D   
##D   s2km <- Kmm(seedlings2, r=1:100)
##D   
##D   plot(s1km, ylime=c(0.6,1.2), lwd=2, maine="", xlabe="r(cm)")
##D 
##D   plot(s2km,  lwd=2, lty=2, add=T )
##D 
##D   abline(h=1, lwd=2, lty=3)
##D   
##D   legend(x=60, y=1.2, legend=c("Hs_C1", "Hs_C2", "H0"),
##D          lty=c(1, 2, 3), lwd=c(3, 2, 2), bty="n")
##D  
##D ## A pointwise test of normalized Kmm == 1 for seedlings1:
##D 
##D    s1km.test <- Kmm(seedlings1, r=1:100, nsim=99)
##D 
##D    plot(s1km.test,  xlabe="r(cm)")
##D 
##D   
## End(Not run)



