### Name: ipc.estK
### Title: Fit the (In)homogeneous Poisson Cluster Point Process by Minimum
###   Contrast
### Aliases: ipc.estK plot.ecespa.minconfit print.ecespa.minconfit
###   ecespa.minconfit
### Keywords: spatial

### ** Examples

## Not run: 
##D 
##D #####################
##D ## Same example as in pc.estK
##D 
##D data(gypsophylous)
##D 
##D ## Estimate K function ("Kobs").
##D 
##D gyps.env <- envelope(gypsophylous, Kest, correction="iso", nsim=99)
##D 
##D plot(gyps.env, sqrt(./pi)-r~r)
##D 
##D ## Fit Poisson Cluster Process. The limits of integration 
##D ## rmin and rmax are setup to 0 and 60, respectively. 
##D 
##D cosa.pc2 <- ipc.estK(gypsophylous, r = gyps.env$r[gyps.env$r<=60])
##D 
##D ## Add fitted Kclust function to the plot.
##D 
##D plot(cosa.pc2, add=T, lwd=c(3,3))
##D 
##D ## A kind of pointwise test of the gypsophylous pattern been a realisation
##D ## of the fitted model, simulating with sim.poissonc and using function J (Jest).
##D 
##D gyps.env.sim2 <- envelope(gypsophylous, Jest, nsim=99,
##D                     simulate=expression(rIPCP(cosa.pc2)))
##D 
##D plot(gyps.env.sim2,  main="")
##D 
##D #####################
##D ## Inhomogeneous example
##D 
##D data(urkiola)
##D 
##D # get univariate pp
##D I.ppp <- split.ppp(urkiola)$birch
##D 
##D #estimate inhomogeneous intensity function
##D I.lam <- predict (ppm(I.ppp, ~polynom(x,y,2)), type="trend", ngrid=200)
##D 
##D # Compute and plot envelopes to Kinhom, simulating from an Inhomogeneous Poisson Process:
##D I2.env <- envelope( I.ppp,Kinhom, lambda=I.lam, correction="trans", 
##D                             nsim=99, simulate=expression(rpoispp(I.lam)))
##D plot(I2.env, sqrt(./pi)-r~r) 
##D 
##D # It seems that there is short scale clustering; lets fit an IPCP: 
##D 
##D I.ki <- ipc.estK(mippp=I.ppp, lambda=I.lam, correction="trans")
##D 
##D # Compute and plot envelopes to Kinhom, simulating from the fitted IPCP:
##D 
##D Ipc.env= Ki(I.ki, correction="trans", nsim=99, ngrid=200)
##D plot (Ipc.env)
##D 
## End(Not run)



