### Name: pc.estK
### Title: Fit the Poisson Cluster Point Process by Minimum Contrast
### Aliases: pc.estK Kclust
### Keywords: spatial

### ** Examples

## Not run: 
##D 
##D data(gypsophylous)
##D 
##D ## Estimate K function ("Kobs").
##D 
##D gyps.env <- envelope(gypsophylous, Kest, correction="iso", nsim=99)
##D 
##D plot(gyps.env, sqrt(./pi)-r~r)
##D 
##D ## Fit Poisson Cluster Process. The limits of integration 
##D ## rmin and rmax are setup to 0 and 60, respectively. 
##D 
##D cosa.pc <- pc.estK(Kobs = gyps.env$obs[gyps.env$r<=60],
##D                            r = gyps.env$r[gyps.env$r<=60])
##D 
##D ## Add fitted Kclust function to the plot.
##D 
##D lines(gyps.env$r,sqrt(Kclust(gyps.env$r, cosa.pc$sigma2,cosa.pc$rho)/pi)-gyps.env$r,
##D        lty=2, lwd=3, col="purple")
##D 
##D ## A kind of pointwise test of the gypsophylous pattern been a realisation
##D ## of the fitted model, simulating with sim.poissonc and using function J (Jest).
##D 
##D gyps.env.sim <- envelope(gypsophylous, Jest, nsim=99,
##D                     simulate=expression(sim.poissonc(gypsophylous,
##D                     sigma=sqrt(cosa.pc$sigma2), rho=cosa.pc$rho)))
##D 
##D plot(gyps.env.sim,  main="")
##D 
## End(Not run)



