### Name: rIPCP
### Title: Simulate Inhomogeneous Poisson Cluster Process
### Aliases: rIPCP
### Keywords: spatial

### ** Examples

  ## Not run: 
##D   
##D     data(gypsophylous)
##D   
##D     plot(gypsophylous) 
##D     
##D     ## It 'seems' that the pattern is clustered, so 
##D     ## fit a Poisson Cluster Process. The limits of integration 
##D     ## rmin and rmax are setup to 0 and 60, respectively.
##D     
##D    cosa.pc2 <- ipc.estK(gypsophylous, r = seq(0, 60, by=0.2))
##D 
##D    ## Create one instance of the fitted PCP:
##D 
##D    pointp <- rIPCP( cosa.pc2)
##D    
##D    plot(pointp)
##D    
##D    
##D    
##D     #####################
##D     ## Inhomogeneous example
##D 
##D     data(urkiola)
##D 
##D     # get univariate pp
##D     I.ppp <- split.ppp(urkiola)$birch
##D 
##D     plot(I.ppp)
##D 
##D     #estimate inhomogeneous intensity function
##D     I.lam <- predict (ppm(I.ppp, ~polynom(x,y,2)), type="trend", ngrid=200)
##D 
##D     # It seems that there is short scale clustering; lets fit an IPCP: 
##D 
##D     I.ki <- ipc.estK(mippp=I.ppp, lambda=I.lam, correction="trans")
##D 
##D     ## Create one instance of the fitted PCP:
##D 
##D     pointpi <- rIPCP( I.ki)
##D    
##D     plot(pointpi)
##D  
## End(Not run)




