Kmulti.ls               package:ecespa               R Documentation

_L_o_t_w_i_c_k'_s _a_n_d _S_i_l_v_e_r_m_a_n'_s _c_o_m_b_i_n_e_d _e_s_t_i_m_a_t_o_r _o_f _t_h_e _m_a_r_k_e_d _K-_f_u_n_c_t_i_o_n

_D_e_s_c_r_i_p_t_i_o_n:

     For a multitype point pattern, calculates the combined estimator
     of the bivariate Kij(r) and Kji(r) functions.

_U_s_a_g_e:

     Kmulti.ls(X, I, J, r = NULL, corre = "isotropic")

_A_r_g_u_m_e_n_t_s:

       X: Multitype marked point pattern. An object with the 'ppp'
          format of 'spatstat'.

       I: Subset index specifying the points of the first pattern.  

       J: Subset index specifying the points of the second pattern. 

       r: Numeric vector. The values of the argument r at which the
          multitype K function K^*ij(r) should be evaluated. 

   corre: A character item selecting any of the options "border",
          "bord.modif", "isotropic", "Ripley" or "translate", as
          described in 'Kest'. It specifies the edge correction(s) to
          be applied. 

_D_e_t_a_i_l_s:

     As a consequence of edge effects, the estimators  Kij(r) and
     Kji(r) of the same bivariate pattern could differ. K^*ij(r) is the
     combined estimator defined by Lotwick and Silverman (1982) as 

                  nj*Kij(r)+ ni*Kji(r) / (ni + nj) ,

     ni and nj being respectively the number of points in I and J.

_V_a_l_u_e:

     An object of class "fv"  (see 'fv.object'). Essentially a data
     frame containing numeric columns  

      r : The values of the argument r at which the function K^*ij(r) 
          has been estimated

   theo : The theoretical value of K*ij(r) for a marked Poisson
          process, namely pi * r^2

     .

     together with a column or columns named "border", "bord.modif",
     "iso" and/or "trans", according to the selected edge corrections.
     These columns contain estimates of the function K^*ij(r) obtained
     by the edge corrections named.

_N_o_t_e:

     'Kmulti.ls' is a wrapper for a convenient use of the 'Kmulti'
     function of 'spatstat'.  Please refer to its help page for
     additional documentation.

_A_u_t_h_o_r(_s):

     Marcelino de la Cruz. marcelino.delacruz@upm.es

_R_e_f_e_r_e_n_c_e_s:

     Lotwick,H.W. & Silverman, B. W. 1982. Methods for analysing
     spatial processes of several types of points.  _Journal of the
     Royal Statistical Society_ B *44*: 406-413.

_E_x_a_m_p_l_e_s:

     ## Not run: 
     data(amacrine)

     plot(Kmulti.ls(amacrine, I=amacrine$marks=="on", J=amacrine$marks=="off", 
              corre="isotropic"), sqrt(./pi)-r~r, main="")

     # compare with Kmulti

     plot(Kmulti(amacrine, I=amacrine$marks=="on", J=amacrine$marks=="off"),
              sqrt(iso/pi)-r~r, add=TRUE, col=3)

     plot(Kmulti(amacrine, J=amacrine$marks=="on", I=amacrine$marks=="off"),
           sqrt(iso/pi)-r~r, add=TRUE, col=4)
     ## End(Not run)

