### Name: effect
### Title: Functions For Constructing Effect Plots
### Aliases: effect effect.lm effect.multinom effect.polr allEffects
###   as.data.frame.eff as.data.frame.effpoly as.data.frame.efflatent
### Keywords: hplot models

### ** Examples

mod.cowles <- glm(volunteer ~ sex + neuroticism*extraversion, 
    data=Cowles, family=binomial)
eff.cowles <- allEffects(mod.cowles, xlevels=list(neuroticism=0:24, 
    extraversion=seq(0, 24, 6)), given.values=c(sexmale=0.5))
eff.cowles

plot(eff.cowles, 'sex', ylab="Prob(Volunteer)")

plot(eff.cowles, 'neuroticism:extraversion', ylab="Prob(Volunteer)",
    ticks=list(at=c(.1,.25,.5,.75,.9)))

plot(eff.cowles, 'neuroticism:extraversion', multiline=TRUE, 
    ylab="Prob(Volunteer)")
    
plot(effect('sex:neuroticism:extraversion', mod.cowles,
    xlevels=list(neuroticism=0:24, extraversion=seq(0, 24, 6))), multiline=TRUE)

mod.beps <- multinom(vote ~ age + gender + economic.cond.national +
                                economic.cond.household + Blair + Hague + Kennedy +
                                Europe*political.knowledge, data=BEPS)
plot(effect("Europe*political.knowledge", mod.beps, 
        xlevels=list(Europe=1:11, political.knowledge=0:3)))
        
plot(effect("Europe*political.knowledge", mod.beps, 
                xlevels=list(Europe=1:11, political.knowledge=0:3),
                given.values=c(gendermale=0.5)),
        style="stacked", colors=c("blue", "red", "orange"), rug=FALSE)
        
mod.wvs <- polr(poverty ~ gender + religion + degree + country*poly(age,3),
        data=WVS)
plot(effect("country*poly(age, 3)", mod.wvs))

plot(effect("country*poly(age, 3)", mod.wvs), style="stacked")
        
plot(effect("country*poly(age, 3)", latent=TRUE, mod.wvs))

mod.pres <- lm(prestige ~ log(income, 10) + poly(education, 3) + poly(women, 2), 
    data=Prestige)
eff.pres <- allEffects(mod.pres, default.levels=50)
plot(eff.pres, ask=FALSE)




