### Name: epi.2by2
### Title: Summary measures for count data presented in a 2 by 2 table
### Aliases: epi.2by2
### Keywords: univar

### ** Examples

## EXAMPLE 1
## A cross sectional study investigating the relationship between dry cat 
## food (DCF) and feline urologic syndrome (FUS) was conducted (Willeberg 
## 1977). Counts of individuals in each group were as follows:

## DCF-exposed cats (cases, non-cases) 13, 2163
## Non DCF-exposed cats (cases, non-cases) 5, 3349

epi.2by2(a = 13, b = 2163, c = 5, d = 3349, method = "cross.sectional", 
   conf.level = 0.95, units = 100, verbose = FALSE)

## Risk ratio:
## The incidence risk of FUS in DCF exposed cats is 4.01 times (95% CI 1.43 to 
## 11.23) greater than the incidence risk of FUS in non-DCF exposed cats.

## Attributable fraction:
## In DCF exposed cats, 75% of FUS is attributable to DCF (95% CI 30% to 91%).

## Population attributable fraction:
## Fifty-four percent of FUS cases in the cat population are attributable 
## to DCF (95% CI 4% to 78%).

## EXAMPLE 2
## A study was conducted by Feychting et al (1998) comparing cancer occurrence
## among the blind with occurrence among those who were not blind but had 
## severe visual impairment. From these data we calculate a cancer rate of
## 136/22050 person-years among the blind compared with 1709/127650 person-
## years among those who were visually impaired but not blind.

rval <- epi.2by2(a = 136, b = 22050, c = 1709, d = 127650, method = 
   "cohort.time", conf.level = 0.90, units = 1000, verbose = TRUE)
round(rval$AR, digits = 3)

## The incidence rate of cancer was 7.22 cases per 1000 person-years less in the 
## blind, compared with those who were not blind but had severe visual impairment
## (90% CI 6.20 to 8.24 cases per 1000 person-years).

round(rval$IRR, digits = 3)   

## The incidence rate of cancer in the blind group was less than half that of the 
## comparison group (incidence rate ratio 0.46, 90% CI 0.40 to 0.53).

## EXAMPLE 3
## The results of an unmatched case control study of the association between
## smoking and cervical cancer were stratified by age. Counts of individuals 
## in each group were as follows: 

## Age group 20 - 29 years (cases, controls)
## Smokers: 41, 6
## Non-smokers: 13, 53

## Age group 30 - 39 years (cases, controls)
## Smokers: 66, 25
## Non-smokers: 37, 83

## Age +40 years (cases, controls)
## Smokers: 23, 14
## Non-smokers: 37, 62

a <- c(41, 66, 23)
b <- c(6, 25, 14)
c <- c(13, 37, 37)
d <- c(53, 83, 62)
tmp.2by2 <- epi.2by2(a, b, c, d, method = "case.control", conf.level = 0.95, 
   units = 100, verbose = TRUE)
tmp.2by2

## Crude odds ratio:
## 6.57 (95% CI 4.31 to 10.03)
  
## Mantel-Haenszel adjusted odds ratio:
## 6.27 (95% CI 3.52 to 11.17)

## Summary chi-squared test for difference in proportions:
## Test statistic 83.31; df = 1; P < 0.01

## Test of homeogeneity of odds ratios:
## Test statistic 2.09; df = 2; P = 0.35

## We accept the null hypothesis that the strata level odds ratios 
## are homogenous. The crude odds ratio is 6.57 (95% CI 4.31 -- 10.03). 
## The Mantel-Haenszel adjusted odds ratio is 6.27 (95% CI 3.52 to 11.17). 
## The crude odds ratio is 1.05 times the magnitude of the Mantel-Haenszel 
## adjusted odds ratio so we conclude that age does not confound the association 
## between smoking and risk of cervical cancer (using a ratio of greater 
## than 1.10 or less than 0.90 as indicative of the presence of confounding).

## Now plot the individual strata-level odds ratio and compare them with the 
## Mantel-Haenszel adjusted odds ratio.

## Not run: 
## Not run: library(latticeExtra)
##D nstrata <- 1:length(a)
##D strata.lab <- paste("Strata ", nstrata, sep = "")
##D y.at <- c(nstrata, max(nstrata) + 1)
##D y.labels <- c("Mantel-Haenszel", strata.lab)
##D x.labels <- c(0.5, 1, 2, 4, 8, 16, 32, 64, 128)
##D 
##D or.l <- c(tmp.2by2$OR.summary$lower, tmp.2by2$OR$lower)
##D or.u <- c(tmp.2by2$OR.summary$upper, tmp.2by2$OR$upper)
##D or.p <- c(tmp.2by2$OR.summary$est, tmp.2by2$OR$est)
##D vert <- 1:length(or.p)
##D  
##D segplot(vert ~ or.l + or.u, centers = or.p, horizontal = TRUE, 
##D    aspect = 1/2, col = "grey", 
##D    ylim = c(0,vert + 1), 
##D    xlab = "Odds ratio", ylab = "", 
##D    scales = list(y = list(at = y.at, labels = y.labels, ticks = FALSE)), 
##D    main = "Strata level and summary measures of association")
## End(Not run)
## End(Not run)

## In this example the precision of both strata 2 and 3 odds ratio estimates is
## high (i.e. the confidence intervals are narrow) so strata 2 and 3 carry most 
## of the weight in determining the value of the Mantel-Haenszel adjusted 
## odds ratio. 




