### Name: epi.cluster2size
### Title: Sample size under under two-stage cluster sampling
### Aliases: epi.cluster2size
### Keywords: univar univar

### ** Examples

## We intend to conduct a survey of nurse practitioners to estimate the 
## average number of patients seen by each nurse. There are five health
## centres in the study area, each with three nurses. We intend to sample
## two nurses from each health centre. We would like to be 95% confident
## of obtaining an estimate that is within 30% of the true value. We 
## expect that the mean number of patients seen at the health centre level 
## is 84 (var 567) and the mean number of patients seen at the nurse 
## level is 28 (var 160). How many health centres should we sample?

nbar <- 2
n <- c(5, 3)
mean <- c(84, 28)
var <- c(567, 160)
epi.cluster2size(nbar, n, mean, var, epsilon = 0.3, method = "mean", 
   conf.level = 0.95)

## We would need a simple two-stage cluster sample of 3 health centres to 
## meet these specifications.



