### Name: epi.edr
### Title: Estimated dissemination ratio
### Aliases: epi.edr
### Keywords: univar

### ** Examples

set.seed(123)
dat <- rpois(n = 50, lambda = 2) 
edr.04 <- epi.edr(dat, n = 4, conf.level = 0.95, nsim = 99, na.zero = TRUE)

## Plot:
plot(1:50, 1:50, xlim = c(0,25), ylim = c(0, 10), xlab = "Days",
   ylab = "Estimated dissemination ratio", type = "n", main = "")
lines(1:50, edr.04[,1], type = "l", lwd = 2, lty = 1, col = "blue")
lines(1:50, edr.04[,2], type = "l", lwd = 1, lty = 2, col = "blue")
lines(1:50, edr.04[,3], type = "l", lwd = 1, lty = 2, col = "blue")




