### Name: epi.empbayes
### Title: Empirical Bayes estimates
### Aliases: epi.empbayes
### Keywords: univar univar

### ** Examples

data(epi.SClip)
obs <- epi.SClip$cases
pop <- epi.SClip$population

est <- epi.empbayes(obs, pop)
empbayes.prop <- (obs + est[4]) / (pop + est[3])
raw.prop <- (obs) / (pop)
rank <- rank(raw.prop)
dat <- as.data.frame(cbind(rank, raw.prop, empbayes.prop))

plot(dat$rank, dat$raw.prop, type = "n", xlab = "Rank", ylab = "Proportion")
points(dat$rank, dat$raw.prop, pch = 16, col = "red")
points(dat$rank, dat$empbayes.prop, pch = 16, col = "blue")
legend(5, 0.00025, legend = c("Raw estimate", "Bayes adjusted estimate"), 
   col = c("red","blue"), pch = c(16,16), bty = "n")



