### Name: epi.indirectadj
### Title: Indirectly adjusted rates
### Aliases: epi.indirectadj
### Keywords: univar

### ** Examples

## EXAMPLE 1
## Data have been collected on the incidence of tuberculosis in two
## areas, for two herd types: dairy and beef.

obs <- matrix(data = c(17, 41, 10, 120), nrow = 2, byrow = TRUE, 
   dimnames = list(c("A", "B"), c("beef", "dairy")))
pop <- matrix(data = c(550, 450, 500, 1500), nrow = 2, byrow = TRUE, 
   dimnames = list(c("A", "B"), c("beef", "dairy")))
epi.indirectadj(obs, pop, std = "NA", type = "rate", conf.level = 0.05)

## The crude incidence risk of tuberculosis in area A was 0.058 cases per year.
## The crude incidence risk of tuberculosis in area B was 0.065 cases per year. 
## The indirectly adjusted incidence risk of tuberculosis in area A was 0.071 
## cases per year. The indirectly adjusted incidence risk of tuberculosis in 
## area B was 0.059 cases per year. 

## Repeat the analysis, explicitly defining the standard incidence risks
## for beef, dairy, and the total population as 0.025, 0.085, and 0.060
## cases per herd per year, respectively:

std <- c(0.025, 0.085, 0.060)
epi.indirectadj(obs, pop, std = std, type = "rate", conf.level = 0.05)

## The indirectly adjusted incidence risk of tuberculosis in area A was 0.067 
## cases per year. The indirectly adjusted incidence risk of tuberculosis in 
## area B was 0.056 cases per year. 




