### Name: epi.insthaz
### Title: Instantaneous hazard computed on the basis of a Kaplan-Meier
###   survival function
### Aliases: epi.insthaz
### Keywords: univar univar

### ** Examples

library(survival)
ovarian.km <- survfit(Surv(futime,fustat) ~ 1, data = ovarian)

ovarian.haz <- epi.insthaz(ovarian.km, conf.level = 0.95)
plot(ovarian.haz$time, ovarian.haz$est, xlab = "Days", 
   ylab = "Instantaneous hazard", type = "b", pch = 16)




