### Name: epi.simplesize
### Title: Sample size under under simple random sampling
### Aliases: epi.simplesize
### Keywords: univar univar

### ** Examples

## EXAMPLE 1
## We want to estimate the mean bodyweight of deer on a farm. There are 278
## animals present. We anticipate the standard deviation of body weight to be 
## around 30 kg. We would like to be 95% certain that our estimate is within 
## 10 kg of the true mean. How many deer should be sampled?

epi.simplesize(N = 278, sd = 30, Py = NA, epsilon = 10, method = "mean", 
   conf.level = 0.95)

## A sample of 31 deer are required.

## EXAMPLE 2
## We want to estimate the seroprevalence of Brucella abortus in a population 
## of cattle. An estimate of the unknown prevalence of B. abortus in this 
## population is 0.15. We would like to be 95% certain that our estimate is 
## within 20% of the true proportion of the population that is seropositive 
## to B. abortus. Calculate the required sample size.

## Convert relative error into absolute error:
epsilon.r <- 0.20; Py = 0.15
epsilon <- epsilon.r * Py

epi.simplesize(N = 1E+06, sd = NA, Py = Py, epsilon = epsilon, 
   method = "proportion", conf.level = 0.95)

## A sample of 544 cattle are required.




