### Name: epi.tests
### Title: Sensitivity, specificity and predictive value of a diagnostic
###   test
### Aliases: epi.tests
### Keywords: univar

### ** Examples

## Scott et al. 2008, Table 1:
## A new diagnostic test was trialled on 1586 patients. Of 744 patients
## that were disease positive, 670 tested positive. Of 842 patients that 
## were disease negative, 640 tested negative. What is the likeliood
## ratio of a positive test? What is the number needed to diagnose?

a <- 670; b <- 202; c <- 74; d <- 640
epi.tests(a = a, b = b, c = c, d = d, conf.level = 0.95)

## Test sensitivity is 0.90 (95% CI 0.88 -- 0.92). Test specificity is 
## 0.76 (95% CI 0.73 -- 0.79). The likelihood ratio of a positive test 
## is 3.75 (95% CI 3.32 to 4.24). The number needed to diagnose is 
## 1.51 (95% CI 1.41 to 1.65). Around 15 persons need to be tested 
## to return 10 positive tests.



