epi.cp                 package:epiR                 R Documentation

_E_x_t_r_a_c_t _u_n_i_q_u_e _c_o_v_a_r_i_a_t_e _p_a_t_t_e_r_n_s _f_r_o_m _a _d_a_t_a _s_e_t

_D_e_s_c_r_i_p_t_i_o_n:

     Extract the set of unique patterns from a set of covariates.

_U_s_a_g_e:

     epi.cp(dat)

_A_r_g_u_m_e_n_t_s:

     dat: an _i_ row by _j_ column data frame where the _i_ rows
          represent individual observations and the _m_ columns
          represent covariates.

_D_e_t_a_i_l_s:

     A covariate pattern is a unique combination of values of predictor
     variables. For example, if a model contains two dichotomous
     predictors, there will be four covariate patterns possible:
     '(1,1)', '(1,0)', '(0,1)', and '(0,0)'. This function extracts the
     _n_ unique covariate patterns from a data set comprised of _i_
     observations, labelling them from 1 to _n_. A vector of length _m_
     is also returned, listing the covariate pattern identifier for
     each observation.

_V_a_l_u_e:

     A list containing the following: 

cov.pattern: a data frame with columns: 'id' the unique covariate
          patterns, 'n' the number of occasions each of the listed
          covariate pattern appears in the data, and the unique
          covariate combinations.

      id: a vector listing the covariate pattern identifier for each
          observation.

_R_e_f_e_r_e_n_c_e_s:

     Dohoo I, Martin W, Stryhn H (2003). Veterinary Epidemiologic
     Research. AVC Inc, Charlottetown, Prince Edward Island, Canada.

_E_x_a_m_p_l_e_s:

     ## Generate a set of covariates:
     set.seed(seed = 1234)
     obs <- round(runif(n = 100, min = 0, max = 1), digits = 0)
     v1 <- round(runif(n = 100, min = 0, max = 4), digits = 0)
     v2 <- round(runif(n = 100, min = 0, max = 4), digits = 0)
     dat <- as.data.frame(cbind(obs, v1, v2))

     dat.glm <- glm(obs ~ v1 + v2, family = binomial, data = dat)
     dat.mf <- model.frame(dat.glm)

     ## Covariate pattern:
     epi.cp(dat.mf[-1])

     ## There are 25 covariate patterns in this data set. Subject 100 has
     ## covariate pattern 21. 

