epi.dsl                 package:epiR                 R Documentation

_M_i_x_e_d-_e_f_f_e_c_t_s _m_e_t_a-_a_n_a_l_y_s_i_s _o_f _b_i_n_a_r_y _o_u_t_c_o_m_e_s _u_s_i_n_g _t_h_e _D_e_r_S_i_m_o_n_i_a_n _a_n_d _L_a_i_r_d _m_e_t_h_o_d

_D_e_s_c_r_i_p_t_i_o_n:

     Computes individual study odds or risk ratios for binary outcome
     data. Computes the summary odds or risk ratio using the
     DerSimonian and Laird method. Performs a test of heterogeneity
     among trials. Performs a test for the overall difference between
     groups (that is, after pooling the studies, do treated groups
     differ significantly from controls?).

_U_s_a_g_e:

     epi.dsl(ev.trt, n.trt, ev.ctrl, n.ctrl, names, method = "odds.ratio", 
        conf.level = 0.95)

_A_r_g_u_m_e_n_t_s:

  ev.trt: observed number of events in the treatment group.

   n.trt: number in the treatment group.

 ev.ctrl: observed number of events in the control group.

  n.ctrl: number in the control group.

   names: character string identifying each trial.

  method: a character string indicating the method to be used. Options
          are 'odds.ratio' or 'risk.ratio'.

conf.level: magnitude of the returned confidence interval. Must be a
          single number between 0 and 1.

_V_a_l_u_e:

     A list containing the following: 

      OR: the odds ratio for each trial, the standard error of the odds
          ratio for each trial, and the lower and upper bounds of the
          confidence interval of the odds ratio for each trial.

      RR: the risk ratio for each trial, the standard error of the risk
          ratio for each trial, and the lower and upper bounds of the
          confidence interval of the risk ratio for each trial.

OR.summary: the DerSimonian and Laird summary odds ratio, the standard
          error of the DerSimonian and Laird summary odds ratio, the
          lower and upper bounds of the confidence interval of the
          DerSimonian and Laird summary odds ratio.

RR.summary: the DerSimonian and Laird summary risk ratio, the standard
          error of the DerSimonian and Laird summary risk ratio, the
          lower and upper bounds of the confidence interval of the
          DerSimonian and Laird summary risk ratio.

 weights: the inverse variance and DerSimonian and Laird weights for
          each trial.

heterogeneity: a vector containing 'Q' the heterogeneity test
          statistic, 'df' the degrees of freedom and its associated
          P-value.

     Hsq: the relative excess of the  heterogeneity test statistic 'Q'
          over the degrees of freedom 'df'.

     Isq: the percentage of total variation in study estimates that is
          due to heterogeneity rather than chance.

  tau.sq: the variance of the treatment effect among trials.

  effect: a vector containing 'z' the test statistic for overall
          treatment effect and its associated P-value.

_N_o_t_e:

     Under the random-effects model, the assumption of a common
     treatment effect is relaxed, and the effect sizes are assumed to
     have a normal distribution with variance 'tau.sq'.

     Using this method, the DerSimonian and Laird weights are used to
     compute the pooled odds ratio.

     The function checks each strata for cells with zero frequencies.
     If a zero frequency is found in any cell, 0.5 is added to all
     cells within the strata.

_R_e_f_e_r_e_n_c_e_s:

     Deeks JJ, Altman DG, Bradburn MJ (2001). Statistical methods for
     examining heterogeneity and combining results from several studies
     in meta-analysis. In: Egger M, Davey Smith G, Altman D (eds).
     Systematic Review in Health Care Meta-Analysis in Context. British
     Medical Journal, London, 2001, pp. 291 - 299.

     DerSimonian R, Laird N (1986). Meta-analysis in clinical trials.
     Controlled Clinical Trials 7: 177 - 188. 

     Higgins J, Thompson S (2002). Quantifying heterogeneity in a
     meta-analysis. Statistics in Medicine 21: 1539 - 1558.

_S_e_e _A_l_s_o:

     'epi.iv', 'epi.mh', 'epi.smd'

_E_x_a_m_p_l_e_s:

     data(epi.epidural)
     epi.dsl(ev.trt = epi.epidural$ev.trt, n.trt = epi.epidural$n.trt, 
        ev.ctrl = epi.epidural$ev.ctrl, n.ctrl = epi.epidural$n.ctrl, 
        names = as.character(epi.epidural$trial), method = "odds.ratio", 
        conf.level = 0.95)

