### Name: maxsel
### Title: Maximally selected criterion
### Aliases: maxsel
### Keywords: htest

### ** Examples

# load exactmaxsel library
library(exactmaxsel)

# First case: x and y are data vectors
# Simulate x and y
x<-sample(4,30,replace=TRUE)
y<-sample(c(0,1),30,replace=TRUE)

maxsel.test(x=x,y=y,type="ord",statistic="chi2")
maxsel.test(x=x,y=y,type="cat",statistic="gini")

# Second case: x is a contingency table, y=NULL.
x<-matrix(c(8,10,40,13,15,4),2,4,byrow=TRUE)
maxsel.test(x=x,y=NULL,type="ord",statistic="chi2")
maxsel.test(x=x,y=NULL,type="cat",statistic="gini")




