### Name: MultivariateDistribution
### Title: Multivariate Skew Normal and Student-t Distributions
### Aliases: MultivariateDistribution show,fMV-method fMV fMV-class
###   dmvsnorm pmvsnorm rmvsnorm dmvst pmvst rmvst mvFit print.fMV plot.fMV
###   summary.fMV
### Keywords: distribution

### ** Examples

## rmvst - 
   par(mfcol = c(3, 1), cex = 0.7)
   r1 = rmvst(200, dim = 1)
   ts.plot(as.ts(r1), xlab = "r", main = "Student-t 1d")
   r2 = rmvst(200, dim = 2, Omega = matrix(c(1, 0.5, 0.5, 1), 2))
   ts.plot(as.ts(r2), xlab = "r", col = 2:3, main = "Student-t 2d")
   r3 = rmvst(200, dim = 3, mu = c(-1, 0, 1), alpha = c(1, -1, 1), df = 5)
   ts.plot(as.ts(r3), xlab = "r", col = 2:4, main = "Skew Student-t 3d")    
   
## mvFit - 
   # Generate Grid Points:
   n = 51
   x = seq(-3, 3, length = n)
   xoy = cbind(rep(x, n), as.vector(matrix(x, n, n, byrow = TRUE)))
   X = matrix(xoy, n * n, 2, byrow = FALSE)
   head(X)
   # The Bivariate Normal Case:
   Z = matrix(dmvsnorm(X, dim = 2), length(x))
   par (mfrow = c(2, 2), cex = 0.7)
   persp(x, x, Z, theta = -40, phi = 30, col = "steelblue") 
   title(main = "Bivariate Normal Plot")
   image(x, x, Z)
   title(main = "Bivariate Normal Contours")
   contour(x, x, Z, add = TRUE)
   # The Bivariate Skew-Student-t Case:
   mu = c(-0.1, 0.1)
   Omega = matrix(c(1, 0.5, 0.5, 1), 2)
   alpha = c(-1, 1)
   Z = matrix(dmvst(X, 2, mu, Omega, alpha, df = 3), length(x))
   persp(x, x, Z, theta = -40, phi = 30, col = "steelblue") 
   title(main = "Bivariate Student-t Plot")
   image(x, x, Z)
   contour(x, x, Z, add = TRUE)
   title(main = "Bivariate Student-t Contours")



