### Name: gamlssMX
### Title: Function to fit finite mixture of gamlss family distributions
### Aliases: gamlssMX gamlssMXfits
### Keywords: regression

### ** Examples

library(MASS)
data(geyser)
# fitting 2 finite normal mixtures 
m1<-gamlssMX(waiting~1,data=geyser,family=NO, K=2)
#fitting 2 finite gamma mixtures 
m2<-gamlssMX(waiting~1,data=geyser,family=GA, K=2)
# fitting a model for pi
# first create a data frame
geyser1<-matrix(0,ncol=2, nrow=298)
geyser1[,1] <-geyser$waiting[-1]
geyser1[,2] <-geyser$duration[-299]
colnames(geyser1)<- c("waiting", "duration")
geyser1 <-data.frame(geyser1)
# get the best of 5 fits
m3<-gamlssMXfits(n=5, waiting~1, pi.formula=~duration, data=geyser1,family=NO, K=2)
m3




