### Name: trun.r
### Title: Generates Random Values from a Truncated Density Function of a
###   gamlss.family Distribution
### Aliases: trun.r
### Keywords: distribution regression

### ** Examples

# trucated r function
# continuous
#----------------------------------------------------------------------------------------
# left
test1<-trun.r(par=c(0), family="TF", type="left")
rr<-test1(1000)
hist(rr)
#----------------------------------------------------------------------------------------
# right
test2 <- trun.r(par=c(10), family="BCT", type="right")
rr<-test2(1000)
hist(rr)
#----------------------------------------------------------------------------------------
# both
test3<-trun.r(par=c(-3,3), family="TF", type="both")
rr<-test3(1000)
hist(rr)
#----------------------------------------------------------------------------------------
# discrete 
# trucated r function
# left
test1<-trun.r(par=c(0), family="PO", type="left")
tN <- table(Ni <- test1(1000))
 r <- barplot(tN, col='lightblue')
#----------------------------------------------------------------------------------------
# right
test2 <- trun.r(par=c(10), family="NBI", type="right")
tN <- table(Ni <- test2(1000))
 r <- barplot(tN, col='lightblue')
tN <- table(Ni <- test2(1000,mu=5))
  r <- barplot(tN, col='lightblue')
tN <- table(Ni <- test2(1000,mu=10, sigma=.1))
  r <- barplot(tN, col='lightblue')
#----------------------------------------------------------------------------------------
# both 
test3<-trun.r(par=c(0,10), family="NBI", type="both")
 tN <- table(Ni <- test3(1000,mu=5))
 r <- barplot(tN, col='lightblue')



